/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.GammaFunction;
import dr.math.MathUtils;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.GammaDistributionImpl;

public class GammaDistribution
implements Distribution {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return GammaDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    protected double shape;
    protected double scale;
    protected int samples;

    public GammaDistribution(double shape, double scale) {
        this.shape = shape;
        this.scale = scale;
        this.samples = 0;
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double value) {
        this.shape = value;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double value) {
        this.scale = value;
    }

    @Override
    public double pdf(double x) {
        return GammaDistribution.pdf(x, this.shape, this.scale);
    }

    @Override
    public double logPdf(double x) {
        return GammaDistribution.logPdf(x, this.shape, this.scale);
    }

    @Override
    public double cdf(double x) {
        return GammaDistribution.cdf(x, this.shape, this.scale);
    }

    @Override
    public double quantile(double y) {
        return GammaDistribution.quantile(y, this.shape, this.scale);
    }

    @Override
    public double mean() {
        return GammaDistribution.mean(this.shape, this.scale);
    }

    @Override
    public double variance() {
        return GammaDistribution.variance(this.shape, this.scale);
    }

    public double nextGamma() {
        return GammaDistribution.nextGamma(this.shape, this.scale);
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double x, double shape, double scale) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x == 0.0) {
            if (shape == 1.0) {
                return 1.0 / scale;
            }
            return 0.0;
        }
        double xs = x / scale;
        if (shape == 1.0) {
            return Math.exp(-xs) / scale;
        }
        double a = Math.exp((shape - 1.0) * Math.log(xs) - xs - GammaFunction.lnGamma(shape));
        return a / scale;
    }

    public static double logPdf(double x, double shape, double scale) {
        if (x < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x == 0.0) {
            if (shape == 1.0) {
                return Math.log(1.0 / scale);
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (shape == 1.0) {
            return -x / scale - Math.log(scale);
        }
        if (shape == 0.0) {
            return -Math.log(x);
        }
        return (shape - 1.0) * Math.log(x / scale) - x / scale - GammaFunction.lnGamma(shape) - Math.log(scale);
    }

    public static double cdf(double x, double shape, double scale) {
        if (x < 0.0 || shape <= 0.0) {
            return 0.0;
        }
        return GammaFunction.incompleteGammaP(shape, x / scale);
    }

    public static double quantile(double y, double shape, double scale) {
        return 0.5 * scale * GammaDistribution.pointChi2(y, 2.0 * shape);
    }

    public static double mean(double shape, double scale) {
        return scale * shape;
    }

    public static double variance(double shape, double scale) {
        return scale * scale * shape;
    }

    public static double nextGamma(double shape, double scale) {
        return GammaDistribution.nextGamma(shape, scale, false);
    }

    public static double nextGamma(double shape, double scale, boolean slowCode) {
        double sample = 0.0;
        if (shape < 1.0E-5) {
            if (shape < 0.0) {
                System.out.println("Negative shape parameter");
                throw new IllegalArgumentException("Negative shape parameter");
            }
            double minimum = 1.0E-20;
            double maximum = 50.0;
            double normalizingConstant = Math.log(maximum) - Math.log(minimum);
            while (Math.exp(-(sample = Math.exp(Math.log(minimum) + normalizingConstant * MathUtils.nextDouble()))) < MathUtils.nextDouble()) {
            }
            return sample;
        }
        if (slowCode && Math.floor(shape) == shape && shape > 4.0) {
            int i = 0;
            while ((double)i < shape) {
                sample += -Math.log(MathUtils.nextDouble());
                ++i;
            }
            return sample * scale;
        }
        if (shape == 1.0) {
            return -Math.log(MathUtils.nextDouble()) * scale;
        }
        if (shape == 2.0) {
            return -Math.log(MathUtils.nextDouble() * MathUtils.nextDouble()) * scale;
        }
        if (shape == 3.0) {
            return -Math.log(MathUtils.nextDouble() * MathUtils.nextDouble() * MathUtils.nextDouble()) * scale;
        }
        if (shape == 4.0) {
            return -Math.log(MathUtils.nextDouble() * MathUtils.nextDouble() * MathUtils.nextDouble() * MathUtils.nextDouble()) * scale;
        }
        do {
            try {
                sample = GammaDistribution.quantile(MathUtils.nextDouble(), shape, scale);
            }
            catch (IllegalArgumentException e) {
                sample = 0.0;
            }
        } while (sample == 0.0);
        return sample;
    }

    public static double nextExpGamma(double shape, double scale, double bias) {
        return GammaDistribution.nextExpGamma(shape, scale, bias, false);
    }

    public static double nextExpGamma(double shape, double scale, double bias, boolean slowCode) {
        double sample;
        int iters = 0;
        if (slowCode) {
            double accept;
            do {
                sample = GammaDistribution.nextGamma(shape, scale);
                accept = Math.exp(-1.0 / (bias * sample));
            } while (MathUtils.nextDouble() > accept);
        } else {
            double accept;
            if (shape < 0.0) {
                return 1.0 / GammaDistribution.nextExpGamma(-shape, bias, scale);
            }
            if (shape == 0.0) {
                double sample2;
                double accept2;
                double rejection_mode = 1.0 / bias;
                double median = Math.sqrt(scale / bias);
                if (rejection_mode < median) {
                    rejection_mode = median;
                }
                double rejection_norm = 1.0 / rejection_mode * Math.exp(-1.0 / (bias * rejection_mode));
                do {
                    sample2 = GammaDistribution.nextGamma(1.0, scale) + median;
                    accept2 = 1.0 / sample2 * Math.exp(-1.0 / (sample2 * bias)) / rejection_norm;
                } while (MathUtils.nextDouble() > accept2 && ++iters < 10000);
                if (iters == 10000) {
                    System.out.println("Severe Warning: nextExpGamma (shape=0) failed to generate a sample - returning bogus value!");
                }
                if (MathUtils.nextDouble() > 0.5) {
                    sample2 = scale / (bias * sample2);
                }
                return sample2;
            }
            if (shape <= 0.0) {
                System.out.println("nextExpGamma: Illegal argument (shape parameter is must be positive)");
                throw new IllegalArgumentException("");
            }
            double x0 = (shape * scale + Math.sqrt(4.0 * scale / bias + shape * shape * scale * scale)) / 2.0;
            double majorandScale = 1.0 / (1.0 / scale - 1.0 / (bias * x0 * x0));
            do {
                sample = GammaDistribution.nextGamma(shape, majorandScale);
                accept = Math.exp(-(sample / x0 - 1.0) * (sample / x0 - 1.0) / (bias * sample));
            } while (MathUtils.nextDouble() > accept && ++iters < 10000);
            if (accept > 1.0) {
                System.out.println("PROBLEM!!  This should be impossible!!  Contact the authors.");
            }
            if (majorandScale < 0.0) {
                System.out.println("PROBLEM!! This should be impossible too!!  Contact the authors.");
            }
            if (iters == 10000) {
                System.out.println("Severe Warning: nextExpGamma failed to generate a sample - returning bogus value!");
            }
        }
        return sample;
    }

    private static double pointChi2(double prob, double v) {
        double s6;
        double s5;
        double s4;
        double s3;
        double s2;
        double b;
        double s1;
        double t;
        double p2;
        double q;
        double a;
        double p1;
        double ch;
        double e = 5.0E-7;
        double aa = 0.6931471805;
        double p = prob;
        double epsi = 0.01;
        if (p < 2.0E-6 || p > 0.999998) {
            epsi = 1.0E-6;
        }
        double g = GammaFunction.lnGamma(v / 2.0);
        double xx = v / 2.0;
        double c = xx - 1.0;
        if (v < -1.24 * Math.log(p)) {
            ch = Math.pow(p * xx * Math.exp(g + xx * 0.6931471805), 1.0 / xx);
            if (ch - 5.0E-7 < 0.0) {
                return ch;
            }
        } else if (v > 0.32) {
            double x = NormalDistribution.quantile(p, 0.0, 1.0);
            ch = v * Math.pow(x * Math.sqrt(p1 = 0.222222 / v) + 1.0 - p1, 3.0);
            if (ch > 2.2 * v + 6.0) {
                ch = -2.0 * (Math.log(1.0 - p) - c * Math.log(0.5 * ch) + g);
            }
        } else {
            ch = 0.4;
            a = Math.log(1.0 - p);
            do {
                q = ch;
                p1 = 1.0 + ch * (4.67 + ch);
                p2 = ch * (6.73 + ch * (6.66 + ch));
                t = -0.5 + (4.67 + 2.0 * ch) / p1 - (6.73 + ch * (13.32 + 3.0 * ch)) / p2;
            } while (Math.abs(q / (ch -= (1.0 - Math.exp(a + g + 0.5 * ch + c * 0.6931471805) * p2 / p1) / t) - 1.0) - epsi > 0.0);
        }
        do {
            double d;
            q = ch;
            p1 = 0.5 * ch;
            t = GammaFunction.incompleteGammaP(xx, p1, g);
            if (!(d < 0.0)) continue;
            throw new IllegalArgumentException("Arguments out of range: t < 0");
        } while (Math.abs(q / (ch += (t = (p2 = p - t) * Math.exp(xx * 0.6931471805 + g + p1 - c * Math.log(ch))) * (1.0 + 0.5 * t * (s1 = (210.0 + (a = 0.5 * t - (b = t / ch) * c) * (140.0 + a * (105.0 + a * (84.0 + a * (70.0 + 60.0 * a))))) / 420.0) - b * c * (s1 - b * ((s2 = (420.0 + a * (735.0 + a * (966.0 + a * (1141.0 + 1278.0 * a)))) / 2520.0) - b * ((s3 = (210.0 + a * (462.0 + a * (707.0 + 932.0 * a))) / 2520.0) - b * ((s4 = (252.0 + a * (672.0 + 1182.0 * a) + c * (294.0 + a * (889.0 + 1740.0 * a))) / 5040.0) - b * ((s5 = (84.0 + 264.0 * a + c * (175.0 + 606.0 * a)) / 2520.0) - b * (s6 = (120.0 + c * (346.0 + 127.0 * c)) / 5040.0)))))))) - 1.0) > 5.0E-7);
        return ch;
    }

    public static void main(String[] args) {
        GammaDistribution.testQuantile(1.0E-10, 0.878328435043444, 0.0013696236839573005);
        GammaDistribution.testQuantile(0.5, 0.878328435043444, 0.0013696236839573005);
        GammaDistribution.testQuantile(0.9999999999, 0.878328435043444, 0.0013696236839573005);
        GammaDistribution.testQuantileCM(1.0E-10, 0.878328435043444, 0.0013696236839573005);
        GammaDistribution.testQuantileCM(0.5, 0.878328435043444, 0.0013696236839573005);
        GammaDistribution.testQuantileCM(0.9999999999, 0.878328435043444, 0.0013696236839573005);
        for (double i = 0.0125; i < 1.0; i += 0.025) {
            System.out.print(i + ": ");
            try {
                System.out.println(new GammaDistributionImpl(0.878328435043444, 0.0013696236839573005).inverseCumulativeProbability(i));
                continue;
            }
            catch (MathException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private static void testQuantile(double y, double shape, double scale) {
        long time = System.currentTimeMillis();
        double value = 0.0;
        for (int i = 0; i < 1000; ++i) {
            value = GammaDistribution.quantile(y, shape, scale);
        }
        value = GammaDistribution.quantile(y, shape, scale);
        long elapsed = System.currentTimeMillis() - time;
        System.out.println("Quantile, " + y + ", for shape=" + shape + ", scale=" + scale + " : " + value + ", time=" + elapsed + "ms");
    }

    private static void testQuantileCM(double y, double shape, double scale) {
        long time = System.currentTimeMillis();
        double value = 0.0;
        try {
            for (int i = 0; i < 1000; ++i) {
                value = new GammaDistributionImpl(shape, scale).inverseCumulativeProbability(y);
            }
            value = new GammaDistributionImpl(shape, scale).inverseCumulativeProbability(y);
        }
        catch (MathException e) {
            e.printStackTrace();
        }
        long elapsed = System.currentTimeMillis() - time;
        System.out.println("commons.maths inverseCDF, " + y + ", for shape=" + shape + ", scale=" + scale + " : " + value + ", time=" + elapsed + "ms");
    }

    private static double KolmogorovSmirnov(List<Double> l1, List<Double> l2) {
        int idx2 = 0;
        int max = 0;
        for (int i = 0; i < l1.size(); ++i) {
            while (idx2 < l2.size() && l2.get(idx2) < l1.get(i)) {
                ++idx2;
            }
            max = Math.max(max, idx2 - i);
        }
        return (double)max / Math.sqrt(2.0 * (double)l1.size());
    }

    private static void testExpGamma2(double shape, double scale, double bias, int iterations, double mean) {
        double s0 = 0.0;
        double s1 = 0.0;
        double s2 = 0.0;
        ArrayList<Double> fast = new ArrayList<Double>(0);
        for (int i = 0; i < iterations; ++i) {
            double sample = GammaDistribution.nextExpGamma(shape, scale, bias, false);
            s0 += 1.0;
            s1 += sample;
            s2 += sample * sample;
            fast.add(sample);
        }
        Collections.sort(fast);
        double expmean = s1 / s0;
        double expvar = (s2 - s1 * s1 / s0) / s0;
        double z = (mean - expmean) / Math.sqrt(expvar / (double)iterations);
        System.out.println("Equal-mean test: (shape=" + shape + " scale=" + scale + " bias=" + bias + " mean=" + expmean + " expected=" + mean + " var=" + expvar + " median=" + fast.get(iterations / 2) + "): z=" + z);
    }

    private static void testExpGamma(double shape, double scale, double bias, int iterations) {
        ArrayList<Double> slow = new ArrayList<Double>(0);
        ArrayList<Double> fast = new ArrayList<Double>(0);
        long time = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            slow.add(GammaDistribution.nextExpGamma(shape, scale, bias, true));
        }
        long slowtime = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            fast.add(GammaDistribution.nextExpGamma(shape, scale, bias, false));
        }
        long fasttime = System.currentTimeMillis() - slowtime;
        Collections.sort(slow);
        Collections.sort(fast);
        System.out.println("KS test for shape=" + shape + ", bias=" + bias + " : " + GammaDistribution.KolmogorovSmirnov(slow, fast) + " and " + GammaDistribution.KolmogorovSmirnov(fast, slow) + " slow=" + (slowtime -= time) + "ms, fast=" + fasttime + "ms");
    }

    private static void test(double shape, double scale, int iterations) {
        ArrayList<Double> slow = new ArrayList<Double>(0);
        ArrayList<Double> fast = new ArrayList<Double>(0);
        for (int i = 0; i < iterations; ++i) {
            slow.add(GammaDistribution.nextGamma(shape, scale, true));
            fast.add(GammaDistribution.nextGamma(shape, scale, false));
        }
        Collections.sort(slow);
        Collections.sort(fast);
        System.out.println("KS test for shape=" + shape + " : " + GammaDistribution.KolmogorovSmirnov(slow, fast) + " and " + GammaDistribution.KolmogorovSmirnov(fast, slow));
    }

    private static void testAddition(double shape, double scale, int N2, int iterations) {
        ArrayList<Double> slow = new ArrayList<Double>(0);
        ArrayList<Double> fast = new ArrayList<Double>(0);
        ArrayList<Double> test = new ArrayList<Double>(0);
        for (int i = 0; i < iterations; ++i) {
            int j;
            double s = 0.0;
            for (j = 0; j < N2; ++j) {
                s += GammaDistribution.nextGamma(shape, scale, true);
            }
            slow.add(s);
            s = 0.0;
            for (j = 0; j < N2; ++j) {
                s += GammaDistribution.nextGamma(shape, scale, false);
            }
            fast.add(s);
            test.add(GammaDistribution.nextGamma(shape * (double)N2, scale, true));
        }
        Collections.sort(slow);
        Collections.sort(fast);
        Collections.sort(test);
        System.out.println("KS test for shape=" + shape + " : slow=" + GammaDistribution.KolmogorovSmirnov(slow, test) + " & " + GammaDistribution.KolmogorovSmirnov(test, slow) + "; fast=" + GammaDistribution.KolmogorovSmirnov(fast, test) + " & " + GammaDistribution.KolmogorovSmirnov(test, fast));
    }
}

