/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.GammaFunction;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.math.distributions.GammaDistribution;

public class InverseGammaDistribution
implements Distribution {
    private double shape;
    private double scale;
    private final double factor;
    private final double logFacor;
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return InverseGammaDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };

    public InverseGammaDistribution(double shape, double scale) {
        this.shape = shape;
        this.scale = scale;
        this.factor = Math.pow(scale, shape) / Math.exp(GammaFunction.lnGamma(shape));
        this.logFacor = shape * Math.log(scale) - GammaFunction.lnGamma(shape);
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double value) {
        this.shape = value;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double value) {
        this.scale = value;
    }

    @Override
    public double pdf(double x) {
        return InverseGammaDistribution.pdf(x, this.shape, this.scale, this.factor);
    }

    @Override
    public double logPdf(double x) {
        return InverseGammaDistribution.logPdf(x, this.shape, this.scale, this.logFacor);
    }

    @Override
    public double cdf(double x) {
        return InverseGammaDistribution.cdf(x, this.shape, this.scale);
    }

    @Override
    public double quantile(double y) {
        return InverseGammaDistribution.quantile(y, this.shape, this.scale);
    }

    @Override
    public double mean() {
        return InverseGammaDistribution.mean(this.shape, this.scale);
    }

    @Override
    public double variance() {
        return InverseGammaDistribution.variance(this.shape, this.scale);
    }

    public double nextInverseGamma() {
        return InverseGammaDistribution.nextInverseGamma(this.shape, this.scale);
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    static double pdf(double x, double shape, double scale, double factor) {
        if (x <= 0.0) {
            return 0.0;
        }
        double a = Math.exp(-scale / x) / Math.pow(x, shape + 1.0);
        return factor * a;
    }

    static double logPdf(double x, double shape, double scale, double factor) {
        if (x <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return factor - (scale / x + (shape + 1.0) * Math.log(x));
    }

    public static double cdf(double x, double shape, double scale) {
        if (x <= 0.0 || shape <= 0.0) {
            return 0.0;
        }
        return GammaFunction.incompleteGammaQ(shape, scale / x);
    }

    public static double quantile(double y, double shape, double scale) {
        GammaDistribution g = new GammaDistribution(shape, scale);
        return 1.0 / g.quantile(1.0 - y);
    }

    public static double mean(double shape, double scale) {
        if (shape > 1.0) {
            return scale / (shape - 1.0);
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double variance(double shape, double scale) {
        if (shape > 2.0) {
            return scale * scale / ((shape - 1.0) * (scale - 1.0) * (scale - 2.0));
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double nextInverseGamma(double shape, double scale) {
        return 1.0 / new GammaDistribution(shape, 1.0 / scale).nextGamma();
    }
}

