/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.GammaFunction;
import dr.math.distributions.MultivariateDistribution;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;

public class InverseWishartDistribution
implements MultivariateDistribution {
    public static final String TYPE = "InverseWishart";
    private int df;
    private int dim;
    private double[][] scaleMatrix;
    private Matrix S;
    private double logNormalizationConstant;

    public InverseWishartDistribution(int df, double[][] scaleMatrix) {
        this.df = df;
        this.scaleMatrix = scaleMatrix;
        this.dim = scaleMatrix.length;
        this.S = new Matrix(scaleMatrix);
        this.computeNormalizationConstant();
    }

    private void computeNormalizationConstant() {
        this.logNormalizationConstant = 0.0;
        try {
            this.logNormalizationConstant = (double)this.df / 2.0 * Math.log(new Matrix(this.scaleMatrix).determinant());
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        this.logNormalizationConstant -= (double)(this.df * this.dim) / 2.0 * Math.log(2.0);
        this.logNormalizationConstant -= (double)(this.dim * (this.dim - 1)) / 4.0 * Math.log(Math.PI);
        for (int i = 1; i <= this.dim; ++i) {
            this.logNormalizationConstant -= GammaFunction.lnGamma((double)(this.df + 1 - i) / 2.0);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public double[][] getScaleMatrix() {
        return this.scaleMatrix;
    }

    @Override
    public double[] getMean() {
        return null;
    }

    public int df() {
        return this.df;
    }

    public double[][] scaleMatrix() {
        return this.scaleMatrix;
    }

    @Override
    public double logPdf(double[] x) {
        Matrix W = new Matrix(x, this.dim, this.dim);
        double logDensity = 0.0;
        try {
            logDensity = Math.log(W.determinant());
            logDensity *= -0.5;
            logDensity *= (double)(this.df + this.dim + 1);
            Matrix product = this.S.product(W.inverse());
            for (int i = 0; i < this.dim; ++i) {
                logDensity -= 0.5 * product.component(i, i);
            }
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        return logDensity += this.logNormalizationConstant;
    }
}

