/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;

public class LogNormalDistribution
implements Distribution {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return LogNormalDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    protected double M;
    protected double S;

    public LogNormalDistribution(double M, double S) {
        this.M = M;
        this.S = S;
    }

    public final double getM() {
        return this.M;
    }

    public final void setM(double M) {
        this.M = M;
    }

    public final double getS() {
        return this.S;
    }

    public final void setS(double S) {
        this.S = S;
    }

    @Override
    public double pdf(double x) {
        return LogNormalDistribution.pdf(x, this.M, this.S);
    }

    @Override
    public double logPdf(double x) {
        return LogNormalDistribution.logPdf(x, this.M, this.S);
    }

    @Override
    public double cdf(double x) {
        return LogNormalDistribution.cdf(x, this.M, this.S);
    }

    @Override
    public double quantile(double y) {
        return LogNormalDistribution.quantile(y, this.M, this.S);
    }

    @Override
    public double mean() {
        return LogNormalDistribution.mean(this.M, this.S);
    }

    @Override
    public double variance() {
        return LogNormalDistribution.variance(this.M, this.S);
    }

    public double mode() {
        return LogNormalDistribution.mode(this.M, this.S);
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double x, double M, double S) {
        if (x <= 0.0) {
            return 0.0;
        }
        return NormalDistribution.pdf(Math.log(x), M, S) / x;
    }

    public static double logPdf(double x, double M, double S) {
        if (x < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return NormalDistribution.logPdf(Math.log(x), M, S) - Math.log(x);
    }

    public static double cdf(double x, double M, double S) {
        if (x < 0.0) {
            return 0.0;
        }
        return NormalDistribution.cdf(Math.log(x), M, S, false);
    }

    public static double quantile(double z, double M, double S) {
        return Math.exp(NormalDistribution.quantile(z, M, S));
    }

    public static double mean(double M, double S) {
        return Math.exp(M + S * S / 2.0);
    }

    public static double mode(double M, double S) {
        return Math.exp(M - S * S);
    }

    public static double variance(double M, double S) {
        double S2 = S * S;
        return Math.exp(S2 + 2.0 * M) * (Math.exp(S2) - 1.0);
    }
}

