/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.ErrorFunction;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class NormalDistribution
implements Distribution {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return NormalDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    protected double m;
    protected double sd;
    private static final double[] a = new double[]{2.2352520354606837, 161.02823106855587, 1067.6894854603709, 18154.98125334356, 0.06568233791820745};
    private static final double[] b = new double[]{47.202581904688245, 976.0985517377767, 10260.932208618979, 45507.78933502673};
    private static final double[] c = new double[]{0.39894151208813466, 8.883149794388377, 93.50665613217785, 597.2702763948002, 2494.5375852903726, 6848.190450536283, 11602.65143764735, 9842.714838383978, 1.0765576773720192E-8};
    private static final double[] d = new double[]{22.266688044328117, 235.387901782625, 1519.3775994075547, 6485.558298266761, 18615.571640885097, 34900.95272114598, 38912.00328609327, 19685.429676859992};
    private static final double[] p_ = new double[]{0.215898534057957, 0.12740116116024736, 0.022235277870649807, 0.0014216191932278934, 2.9112874951168793E-5, 0.023073441764940174};
    private static final double[] q = new double[]{1.284260096144911, 0.4682382124808651, 0.06598813786892856, 0.0037823963320275824, 7.297515550839662E-5};
    private static final int CUTOFF = 16;
    private static final double M_SQRT_32 = 5.656854249492381;
    private static final double M_1_SQRT_2PI = 0.3989422804014327;
    private static final double DBL_EPSILON = 2.220446049250313E-16;

    public NormalDistribution(double mean, double sd) {
        this.m = mean;
        this.sd = sd;
    }

    public double getMean() {
        return this.m;
    }

    public void setMean(double value) {
        this.m = value;
    }

    public double getSD() {
        return this.sd;
    }

    public void setSD(double value) {
        this.sd = value;
    }

    @Override
    public double pdf(double x) {
        return NormalDistribution.pdf(x, this.m, this.sd);
    }

    @Override
    public double logPdf(double x) {
        return NormalDistribution.logPdf(x, this.m, this.sd);
    }

    @Override
    public double cdf(double x) {
        return NormalDistribution.cdf(x, this.m, this.sd);
    }

    @Override
    public double quantile(double y) {
        return NormalDistribution.quantile(y, this.m, this.sd);
    }

    @Override
    public double mean() {
        return NormalDistribution.mean(this.m, this.sd);
    }

    @Override
    public double variance() {
        return NormalDistribution.variance(this.m, this.sd);
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double x, double m, double sd) {
        double a = 1.0 / (Math.sqrt(Math.PI * 2) * sd);
        double b = -(x - m) * (x - m) / (2.0 * sd * sd);
        return a * Math.exp(b);
    }

    public static double logPdf(double x, double m, double sd) {
        double a = 1.0 / (Math.sqrt(Math.PI * 2) * sd);
        double b = -(x - m) * (x - m) / (2.0 * sd * sd);
        return Math.log(a) + b;
    }

    public static double cdf(double x, double m, double sd) {
        return NormalDistribution.cdf(x, m, sd, false);
    }

    public static double quantile(double z, double m, double sd) {
        return m + Math.sqrt(2.0) * sd * ErrorFunction.inverseErf(2.0 * z - 1.0);
    }

    public static double mean(double m, double sd) {
        return m;
    }

    public static double variance(double m, double sd) {
        return sd * sd;
    }

    public static double cdf(double x, double mu, double sigma, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(mu) || Double.isNaN(sigma)) {
            return Double.NaN;
        }
        if (Double.isInfinite(x) && mu == x) {
            return Double.NaN;
        }
        if (sigma <= 0.0) {
            if (sigma < 0.0) {
                return Double.NaN;
            }
            return x < mu ? 0.0 : 1.0;
        }
        double p = (x - mu) / sigma;
        if (Double.isInfinite(p)) {
            return x < mu ? 0.0 : 1.0;
        }
        return NormalDistribution.standardCDF(p, log_p);
    }

    public static double standardCDF(double x, boolean log_p) {
        boolean i_tail = false;
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        double p = x;
        double cp = Double.NaN;
        double eps = 1.110223E-16f;
        boolean lower = !i_tail;
        boolean upper = i_tail;
        double y = Math.abs(x);
        if (y <= 0.67448975) {
            double xden;
            double xnum;
            if (y > eps) {
                double xsq = x * x;
                xnum = a[4] * xsq;
                xden = xsq;
                for (int i = 0; i < 3; ++i) {
                    xnum = (xnum + a[i]) * xsq;
                    xden = (xden + b[i]) * xsq;
                }
            } else {
                xden = 0.0;
                xnum = 0.0;
            }
            double temp = x * (xnum + a[3]) / (xden + b[3]);
            if (lower) {
                p = 0.5 + temp;
            }
            if (upper) {
                cp = 0.5 - temp;
            }
            if (log_p) {
                if (lower) {
                    p = Math.log(p);
                }
                if (upper) {
                    cp = Math.log(cp);
                }
            }
        } else if (y <= 5.656854249492381) {
            double xnum = c[8] * y;
            double xden = y;
            for (int i = 0; i < 7; ++i) {
                xnum = (xnum + c[i]) * y;
                xden = (xden + d[i]) * y;
            }
            double temp = (xnum + c[7]) / (xden + d[7]);
            double xsq = (double)((int)(y * 16.0)) * 1.0 / 16.0;
            double del = (y - xsq) * (y + xsq);
            if (log_p) {
                p = -xsq * xsq * 0.5 + -del * 0.5 + Math.log(temp);
                if (lower && x > 0.0 || upper && x <= 0.0) {
                    cp = Math.log(1.0 - Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp);
                }
            } else {
                p = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp;
                cp = 1.0 - p;
            }
            if (x > 0.0) {
                temp = p;
                if (lower) {
                    p = cp;
                }
                cp = temp;
            }
        } else if (log_p || lower && -37.5193 < x && x < 8.2924 || upper && -8.2924 < x && x < 37.5193) {
            double xsq = 1.0 / (x * x);
            double xnum = p_[5] * xsq;
            double xden = xsq;
            for (int i = 0; i < 4; ++i) {
                xnum = (xnum + p_[i]) * xsq;
                xden = (xden + q[i]) * xsq;
            }
            double temp = xsq * (xnum + p_[4]) / (xden + q[4]);
            temp = (0.3989422804014327 - temp) / y;
            xsq = (double)((int)(x * 16.0)) * 1.0 / 16.0;
            double del = (x - xsq) * (x + xsq);
            if (log_p) {
                p = -xsq * xsq * 0.5 + -del * 0.5 + Math.log(temp);
                if (lower && x > 0.0 || upper && x <= 0.0) {
                    cp = Math.log(1.0 - Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp);
                }
            } else {
                p = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp;
                cp = 1.0 - p;
            }
            if (x > 0.0) {
                temp = p;
                if (lower) {
                    p = cp;
                }
                cp = temp;
            }
        } else if (x > 0.0) {
            p = 1.0;
            cp = 0.0;
        } else {
            p = 0.0;
            cp = 1.0;
        }
        return p;
    }

    public static double standardTail(double x, boolean isUpper) {
        double d1;
        if (x < 0.0) {
            isUpper = !isUpper;
            x = -x;
        }
        if (x <= 8.0 || isUpper && x <= 37.0) {
            double d2 = 0.5 * x * x;
            d1 = x >= 1.28 ? 0.398942280385 * Math.exp(-d2) / (x - 3.8052E-8 + 1.00000615302 / (x + 3.98064794E-4 + 1.98615381364 / (x - 0.151679116635 + 5.29330324926 / (x + 4.8385912808 - 15.1508972451 / (x + 0.742380924027 + 30.789933034 / (x + 3.99019417011)))))) : 0.5 - x * (0.398942280444 - 0.399903438504 * d2 / (d2 + 5.75885480458 - 29.8213557808 / (d2 + 2.62433121679 + 48.6959930692 / (d2 + 5.92885724438))));
        } else {
            d1 = 0.0;
        }
        if (!isUpper) {
            d1 = 1.0 - d1;
        }
        return d1;
    }

    public static double tailCDF(double x, double mu, double sigma) {
        return NormalDistribution.standardTail((x - mu) / sigma, true);
    }

    public static double tailCDF(double x, double mu, double sigma, boolean isUpper) {
        return NormalDistribution.standardTail((x - mu) / sigma, isUpper);
    }

    public double tailCDF(double x) {
        return NormalDistribution.standardTail((x - this.m) / this.sd, true);
    }

    static void testTail(double x, double mu, double sigma) {
        double cdf1 = NormalDistribution.cdf(x, mu, sigma);
        double tail1 = 1.0 - cdf1;
        double cdf2 = NormalDistribution.cdf(x, mu, sigma, false);
        double tail2 = 1.0 - cdf2;
        double tail3 = NormalDistribution.tailCDF(x, mu, sigma);
        System.out.println(">" + x + " N(" + mu + ", " + sigma + ")");
        System.out.println("Original CDF: " + tail1);
        System.out.println("     New CDF: " + tail2);
        System.out.println("     tailCDF: " + tail3);
    }

    public static void main(String[] args) {
        NormalDistribution.testTail(0.1, 0.0, 1.0);
        System.out.println();
        NormalDistribution.testTail(1.0, 0.0, 1.0);
        System.out.println();
        NormalDistribution.testTail(5.0, 0.0, 1.0);
        System.out.println();
        NormalDistribution.testTail(7.0, 0.0, 1.0);
        System.out.println();
        NormalDistribution.testTail(8.0, 0.0, 1.0);
        System.out.println();
        NormalDistribution.testTail(8.25, 0.0, 1.0);
        System.out.println();
        NormalDistribution.testTail(10.0, 0.0, 1.0);
    }
}

