/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.ComplexArray;
import dr.math.FastFourierTransform;
import dr.math.distributions.KernelDensityEstimatorDistribution;
import dr.stats.DiscreteStatistics;
import dr.util.HeapSort;

public class NormalKDEDistribution
extends KernelDensityEstimatorDistribution {
    public static final int MINIMUM_GRID_SIZE = 512;
    private ComplexArray kOrdinates;
    private double[] xPoints;
    private double[] densityPoints;
    private int gridSize;
    private double cut;
    private double from;
    private double to;
    private double lo;
    private double up;
    private boolean densityKnown = false;

    public NormalKDEDistribution(Double[] sample) {
        this(sample, null, null, null);
    }

    public NormalKDEDistribution(Double[] sample, Double lowerBound, Double upperBound, Double bandWidth) {
        this(sample, lowerBound, upperBound, bandWidth, 3.0, 512);
    }

    public NormalKDEDistribution(Double[] sample, Double lowerBound, Double upperBound, Double bandWidth, int n) {
        this(sample, lowerBound, upperBound, bandWidth, 3.0, n);
    }

    public NormalKDEDistribution(Double[] sample, Double lowerBound, Double upperBound, Double bandWidth, double cut, int n) {
        super(sample, lowerBound, upperBound, bandWidth);
        this.gridSize = Math.max(n, 512);
        if (this.gridSize > 512) {
            this.gridSize = (int)Math.pow(2.0, Math.ceil(Math.log(this.gridSize) / Math.log(2.0)));
        }
        this.cut = cut;
        this.from = DiscreteStatistics.min(this.sample) - this.cut * this.bandWidth;
        this.to = DiscreteStatistics.max(this.sample) + this.cut * this.bandWidth;
        this.lo = this.from - 4.0 * this.bandWidth;
        this.up = this.to + 4.0 * this.bandWidth;
        this.densityKnown = false;
    }

    public double getFromPoint() {
        return this.from;
    }

    public double getToPoint() {
        return this.to;
    }

    private double linearApproximate(double[] x, double[] y, double pt, double low, double high) {
        int i = 0;
        int j = x.length - 1;
        if (pt < x[i]) {
            return low;
        }
        if (pt > x[j]) {
            return high;
        }
        while (i < j - 1) {
            int ij = (i + j) / 2;
            if (pt < x[ij]) {
                j = ij;
                continue;
            }
            i = ij;
        }
        if (pt == x[j]) {
            return y[j];
        }
        if (pt == x[i]) {
            return y[i];
        }
        return y[i] + (y[j] - y[i]) * ((pt - x[i]) / (x[j] - x[i]));
    }

    private double[] rescaleAndTrim(double[] x) {
        int length = x.length / 2;
        double scale = 1.0 / (double)x.length;
        double[] out = new double[length];
        for (int i = 0; i < length; ++i) {
            out[i] = x[i] * scale;
            if (!(out[i] < 0.0)) continue;
            out[i] = 0.0;
        }
        return out;
    }

    private double[] massdist(double[] x, double xlow, double xhigh, int ny) {
        int nx = x.length;
        double[] y = new double[ny * 2];
        boolean ixmin = false;
        int ixmax = ny - 2;
        double xdelta = (xhigh - xlow) / (double)(ny - 1);
        for (int i = 0; i < ny; ++i) {
            y[i] = 0.0;
        }
        double xmi = 1.0 / (double)nx;
        for (int i = 0; i < nx; ++i) {
            double xpos = (x[i] - xlow) / xdelta;
            int ix = (int)Math.floor(xpos);
            double fx = xpos - (double)ix;
            if (0 <= ix && ix <= ixmax) {
                int n = ix;
                y[n] = y[n] + (1.0 - fx) * xmi;
                int n2 = ix + 1;
                y[n2] = y[n2] + fx * xmi;
                continue;
            }
            if (ix == -1) {
                y[0] = y[0] + fx * xmi;
                continue;
            }
            if (ix != ixmax + 1) continue;
            int n = ix;
            y[n] = y[n] + (1.0 - fx) * xmi;
        }
        return y;
    }

    protected void fillKernelOrdinates(ComplexArray ordinates, double bandWidth) {
        int length = ordinates.length;
        double a = 1.0 / (Math.sqrt(Math.PI * 2) * bandWidth);
        double precision = -0.5 / (bandWidth * bandWidth);
        for (int i = 0; i < length; ++i) {
            double x = ordinates.real[i];
            ordinates.real[i] = a * Math.exp(x * x * precision);
        }
    }

    protected void computeDensity() {
        this.makeOrdinates();
        this.transformData();
        this.densityKnown = true;
    }

    private void transformData() {
        ComplexArray Y = new ComplexArray(this.massdist(this.sample, this.lo, this.up, this.gridSize));
        FastFourierTransform.fft(Y, false);
        ComplexArray product = Y.product(this.kOrdinates);
        FastFourierTransform.fft(product, true);
        this.densityPoints = this.rescaleAndTrim(product.real);
    }

    private void makeOrdinates() {
        int i;
        int length = 2 * this.gridSize;
        if (this.kOrdinates == null) {
            this.kOrdinates = new ComplexArray(new double[length]);
        }
        double max = 2.0 * (this.up - this.lo);
        double value = 0.0;
        double inc = max / (double)(length - 1);
        for (i = 0; i <= this.gridSize; ++i) {
            this.kOrdinates.real[i] = value;
            value += inc;
        }
        for (i = this.gridSize + 1; i < length; ++i) {
            this.kOrdinates.real[i] = -this.kOrdinates.real[length - i];
        }
        this.fillKernelOrdinates(this.kOrdinates, this.bandWidth);
        FastFourierTransform.fft(this.kOrdinates, false);
        this.kOrdinates.conjugate();
        this.xPoints = new double[this.gridSize];
        double x = this.lo;
        double delta = (this.up - this.lo) / (double)(this.gridSize - 1);
        for (int i2 = 0; i2 < this.gridSize; ++i2) {
            this.xPoints[i2] = x;
            x += delta;
        }
    }

    @Override
    protected double evaluateKernel(double x) {
        if (!this.densityKnown) {
            this.computeDensity();
        }
        return this.linearApproximate(this.xPoints, this.densityPoints, x, 0.0, 0.0);
    }

    @Override
    protected void processBounds(Double lowerBound, Double upperBound) {
        if (lowerBound != null && lowerBound != Double.NEGATIVE_INFINITY || upperBound != null && upperBound != Double.POSITIVE_INFINITY) {
            throw new RuntimeException("NormalKDEDistribution must be unbounded");
        }
    }

    @Override
    protected void setBandWidth(Double bandWidth) {
        this.bandWidth = bandWidth == null ? this.bandwidthNRD(this.sample) : bandWidth.doubleValue();
        this.densityKnown = false;
    }

    public double bandwidthNRD(double[] x) {
        int[] indices = new int[x.length];
        HeapSort.sort(x, indices);
        double h = (DiscreteStatistics.quantile(0.75, x, indices) - DiscreteStatistics.quantile(0.25, x, indices)) / 1.34;
        return 1.06 * Math.min(Math.sqrt(DiscreteStatistics.variance(x)), h) * Math.pow(x.length, -0.2);
    }
}

