/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.RombergIntegrator;

public class ReflectedNormalDistribution
implements Distribution {
    double lower;
    double upper;
    double precision;
    double m;
    double sd;
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return ReflectedNormalDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return ReflectedNormalDistribution.this.lower;
        }

        @Override
        public final double getUpperBound() {
            return ReflectedNormalDistribution.this.upper;
        }
    };

    public ReflectedNormalDistribution(double mean, double sd, double lower, double upper, double precision) {
        this.m = mean;
        this.sd = sd;
        this.lower = lower;
        this.upper = upper;
        this.precision = precision;
    }

    public double getMean() {
        return this.m;
    }

    public void setMean(double value) {
        this.m = value;
    }

    public double getSD() {
        return this.sd;
    }

    public void setSD(double value) {
        this.sd = value;
    }

    @Override
    public double pdf(double x) {
        double pdf;
        if (x < this.lower) {
            return 0.0;
        }
        if (x > this.upper) {
            return 0.0;
        }
        double newPDF = pdf = NormalDistribution.pdf(x, this.m, this.sd);
        System.out.println("N(" + x + ",m,sd)=" + pdf);
        int i = 1;
        do {
            pdf = newPDF;
            int A = 2 * ((i + 1) / 2);
            int B = 2 * (i / 2);
            int C = i % 2 == 0 ? -1 : 1;
            double leftPDF = NormalDistribution.pdf((double)A * this.lower - (double)C * x - (double)B * this.upper, this.m, this.sd);
            double rightPDF = NormalDistribution.pdf((double)A * this.upper - (double)C * x - (double)B * this.lower, this.m, this.sd);
            newPDF = leftPDF + rightPDF + pdf;
            ++i;
            System.out.println("newPDF=" + newPDF + " A=" + A + " B=" + B + " C=" + C);
        } while (newPDF - pdf > this.precision);
        return newPDF;
    }

    @Override
    public double logPdf(double x) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double cdf(double x) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double quantile(double y) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static void main(String[] args) {
        final ReflectedNormalDistribution rnd = new ReflectedNormalDistribution(2.0, 2.0, 1.0, 2.0, 1.0E-6);
        rnd.pdf(1.0);
        UnivariateRealFunction f = new UnivariateRealFunction(){

            public double value(double v) throws FunctionEvaluationException {
                return rnd.pdf(v);
            }
        };
        RombergIntegrator integrator = new RombergIntegrator();
        integrator.setAbsoluteAccuracy(1.0E-14);
        integrator.setMaximalIterationCount(16);
        try {
            double x = integrator.integrate(f, rnd.lower, rnd.upper);
            System.out.println("Integrated pdf = " + x);
        }
        catch (ConvergenceException convergenceException) {
        }
        catch (FunctionEvaluationException e) {
            throw new RuntimeException("I have no idea why I am here.");
        }
    }
}

