/*
 * Decompiled with CFR 0.152.
 */
package dr.math.functionEval;

import dr.math.interfaces.OneVariableFunction;

public final class FunctionDerivative
implements OneVariableFunction {
    private OneVariableFunction f;
    private double relativePrecision = 1.0E-4;

    public FunctionDerivative(OneVariableFunction func) {
        this(func, 1.0E-6);
    }

    public FunctionDerivative(OneVariableFunction func, double precision) {
        this.f = func;
        this.relativePrecision = precision;
    }

    @Override
    public double value(double x) {
        double x1 = x == 0.0 ? this.relativePrecision : x * (1.0 + this.relativePrecision);
        double x2 = 2.0 * x - x1;
        return (this.f.value(x1) - this.f.value(x2)) / (x1 - x2);
    }
}

