/*
 * Decompiled with CFR 0.152.
 */
package dr.math.functionEval;

public final class GammaFunction {
    static double sqrt2Pi = Math.sqrt(Math.PI * 2);
    static double[] coefficients = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};

    public static double beta(double x, double y) {
        return Math.exp(GammaFunction.logGamma(x) + GammaFunction.logGamma(y) - GammaFunction.logGamma(x + y));
    }

    public static long factorial(long n) {
        return n < 2L ? 1L : n * GammaFunction.factorial(n - 1L);
    }

    public static double gamma(double x) {
        return x > 1.0 ? Math.exp(GammaFunction.leadingFactor(x)) * GammaFunction.series(x) * sqrt2Pi / x : (x > 0.0 ? GammaFunction.gamma(x + 1.0) / x : Double.NaN);
    }

    private static double leadingFactor(double x) {
        double temp = x + 5.5;
        return Math.log(temp) * (x + 0.5) - temp;
    }

    public static double logBeta(double x, double y) {
        return GammaFunction.logGamma(x) + GammaFunction.logGamma(y) - GammaFunction.logGamma(x + y);
    }

    public static double logGamma(double x) {
        return x > 1.0 ? GammaFunction.leadingFactor(x) + Math.log(GammaFunction.series(x) * sqrt2Pi / x) : (x > 0.0 ? GammaFunction.logGamma(x + 1.0) - Math.log(x) : Double.NaN);
    }

    private static double series(double x) {
        double answer = 1.000000000190015;
        double term = x;
        for (int i = 0; i < 6; ++i) {
            answer += coefficients[i] / (term += 1.0);
        }
        return answer;
    }
}

