/*
 * Decompiled with CFR 0.152.
 */
package dr.math.functionEval;

import dr.math.functionEval.DrMath;
import dr.math.interfaces.OneVariableFunction;
import dr.math.iterations.NewtonZeroFinder;
import java.util.Enumeration;
import java.util.Vector;

public class PolynomialFunction
implements OneVariableFunction {
    private final double[] coefficients;

    public PolynomialFunction(double[] coeffs) {
        this.coefficients = coeffs;
    }

    public PolynomialFunction add(double r) {
        int n = this.coefficients.length;
        double[] coef = new double[n];
        coef[0] = this.coefficients[0] + r;
        for (int i = 1; i < n; ++i) {
            coef[i] = this.coefficients[i];
        }
        return new PolynomialFunction(coef);
    }

    public PolynomialFunction add(PolynomialFunction p) {
        int n = Math.max(p.degree(), this.degree()) + 1;
        double[] coef = new double[n];
        for (int i = 0; i < n; ++i) {
            coef[i] = this.coefficient(i) + p.coefficient(i);
        }
        return new PolynomialFunction(coef);
    }

    public double coefficient(int n) {
        return n < this.coefficients.length ? this.coefficients[n] : 0.0;
    }

    public PolynomialFunction deflate(double r) {
        int n = this.degree();
        double remainder = this.coefficients[n];
        double[] coef = new double[n];
        for (int k = n - 1; k >= 0; --k) {
            coef[k] = remainder;
            remainder = remainder * r + this.coefficients[k];
        }
        return new PolynomialFunction(coef);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public PolynomialFunction derivative() {
        int n = this.degree();
        if (n == 0) {
            double[] coef = new double[]{0.0};
            return new PolynomialFunction(coef);
        }
        double[] coef = new double[n];
        for (int i = 1; i <= n; ++i) {
            coef[i - 1] = this.coefficients[i] * (double)i;
        }
        return new PolynomialFunction(coef);
    }

    public PolynomialFunction divide(double r) {
        return this.multiply(1.0 / r);
    }

    public PolynomialFunction divide(PolynomialFunction p) {
        return this.divideWithRemainder(p)[0];
    }

    public PolynomialFunction[] divideWithRemainder(PolynomialFunction p) {
        int n;
        PolynomialFunction[] answer = new PolynomialFunction[2];
        int m = this.degree();
        if (m < (n = p.degree())) {
            double[] q = new double[]{0.0};
            answer[0] = new PolynomialFunction(q);
            answer[1] = p;
            return answer;
        }
        double[] quotient = new double[m - n + 1];
        double[] coef = new double[m + 1];
        for (int k = 0; k <= m; ++k) {
            coef[k] = this.coefficients[k];
        }
        double norm = 1.0 / p.coefficient(n);
        for (int k = m - n; k >= 0; --k) {
            quotient[k] = coef[n + k] * norm;
            for (int j = n + k - 1; j >= k; --j) {
                int n2 = j;
                coef[n2] = coef[n2] - quotient[k] * p.coefficient(j - k);
            }
        }
        double[] remainder = new double[n];
        for (int k = 0; k < n; ++k) {
            remainder[k] = coef[k];
        }
        answer[0] = new PolynomialFunction(quotient);
        answer[1] = new PolynomialFunction(remainder);
        return answer;
    }

    public PolynomialFunction integral() {
        return this.integral(0.0);
    }

    public PolynomialFunction integral(double value) {
        int n = this.coefficients.length + 1;
        double[] coef = new double[n];
        coef[0] = value;
        for (int i = 1; i < n; ++i) {
            coef[i] = this.coefficients[i - 1] / (double)i;
        }
        return new PolynomialFunction(coef);
    }

    public PolynomialFunction multiply(double r) {
        int n = this.coefficients.length;
        double[] coef = new double[n];
        for (int i = 0; i < n; ++i) {
            coef[i] = this.coefficients[i] * r;
        }
        return new PolynomialFunction(coef);
    }

    public PolynomialFunction multiply(PolynomialFunction p) {
        int n = p.degree() + this.degree();
        double[] coef = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            coef[i] = 0.0;
            for (int k = 0; k <= i; ++k) {
                int n2 = i;
                coef[n2] = coef[n2] + p.coefficient(k) * this.coefficient(i - k);
            }
        }
        return new PolynomialFunction(coef);
    }

    public double[] roots() {
        return this.roots(DrMath.defaultNumericalPrecision());
    }

    public double[] roots(double desiredPrecision) {
        PolynomialFunction dp = this.derivative();
        double start = 0.0;
        while (Math.abs(dp.value(start)) < desiredPrecision) {
            start = Math.random();
        }
        PolynomialFunction p = this;
        NewtonZeroFinder rootFinder = new NewtonZeroFinder(this, dp, start);
        rootFinder.setDesiredPrecision(desiredPrecision);
        Vector<Double> rootCollection = new Vector<Double>(this.degree());
        while (true) {
            rootFinder.evaluate();
            if (!rootFinder.hasConverged()) break;
            double r = rootFinder.getResult();
            rootCollection.addElement(r);
            p = p.deflate(r);
            if (p.degree() == 0) break;
            rootFinder.setFunction(p);
            try {
                rootFinder.setDerivative(p.derivative());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        double[] roots = new double[rootCollection.size()];
        Enumeration e = rootCollection.elements();
        int n = 0;
        while (e.hasMoreElements()) {
            roots[n++] = (Double)e.nextElement();
        }
        return roots;
    }

    public PolynomialFunction subtract(double r) {
        return this.add(-r);
    }

    public PolynomialFunction subtract(PolynomialFunction p) {
        int n = Math.max(p.degree(), this.degree()) + 1;
        double[] coef = new double[n];
        for (int i = 0; i < n; ++i) {
            coef[i] = this.coefficient(i) - p.coefficient(i);
        }
        return new PolynomialFunction(coef);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean firstNonZeroCoefficientPrinted = false;
        for (int n = 0; n < this.coefficients.length; ++n) {
            if (this.coefficients[n] == 0.0) continue;
            if (firstNonZeroCoefficientPrinted) {
                sb.append(this.coefficients[n] > 0.0 ? " + " : " ");
            } else {
                firstNonZeroCoefficientPrinted = true;
            }
            if (n == 0 || this.coefficients[n] != 1.0) {
                sb.append(Double.toString(this.coefficients[n]));
            }
            if (n <= 0) continue;
            sb.append(" X^" + n);
        }
        return sb.toString();
    }

    @Override
    public double value(double x) {
        int n = this.coefficients.length;
        double answer = this.coefficients[--n];
        while (n > 0) {
            answer = answer * x + this.coefficients[--n];
        }
        return answer;
    }

    public double[] valueAndDerivative(double x) {
        int n = this.coefficients.length;
        double[] answer = new double[]{this.coefficients[--n], 0.0};
        while (n > 0) {
            answer[1] = answer[1] * x + answer[0];
            answer[0] = answer[0] * x + this.coefficients[--n];
        }
        return answer;
    }
}

