/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.iterations.IterativeProcess;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.Vector;

public class JacobiTransformation
extends IterativeProcess {
    double[][] rows;
    double[][] transform;
    int p;
    int q;

    public JacobiTransformation(SymmetricMatrix m) {
        int n = m.rows();
        this.rows = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.rows[i][j] = m.components[i][j];
            }
        }
    }

    public double[] eigenvalues() {
        int n = this.rows.length;
        double[] eigenvalues = new double[n];
        for (int i = 0; i < n; ++i) {
            eigenvalues[i] = this.rows[i][i];
        }
        return eigenvalues;
    }

    public Vector[] eigenvectors() {
        int n = this.rows.length;
        Vector[] eigenvectors = new Vector[n];
        double[] temp = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                temp[j] = this.transform[j][i];
            }
            eigenvectors[i] = new Vector(temp);
        }
        return eigenvectors;
    }

    @Override
    public double evaluateIteration() {
        double offDiagonal = this.largestOffDiagonal();
        this.transform();
        return offDiagonal;
    }

    private void exchange(int m) {
        int m1 = m + 1;
        double temp = this.rows[m][m];
        this.rows[m][m] = this.rows[m1][m1];
        this.rows[m1][m1] = temp;
        int n = this.rows.length;
        for (int i = 0; i < n; ++i) {
            temp = this.transform[i][m];
            this.transform[i][m] = this.transform[i][m1];
            this.transform[i][m1] = temp;
        }
    }

    @Override
    public void finalizeIterations() {
        int n = this.rows.length;
        int bound = n - 1;
        while (bound >= 0) {
            int m = -1;
            for (int i = 0; i < bound; ++i) {
                if (!(Math.abs(this.rows[i][i]) < Math.abs(this.rows[i + 1][i + 1]))) continue;
                this.exchange(i);
                m = i;
            }
            bound = m;
        }
    }

    @Override
    public void initializeIterations() {
        this.transform = SymmetricMatrix.identityMatrix((int)this.rows.length).components;
    }

    private double largestOffDiagonal() {
        double value = 0.0;
        int n = this.rows.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double r = Math.abs(this.rows[i][j]);
                if (!(r > value)) continue;
                value = r;
                this.p = i;
                this.q = j;
            }
        }
        return value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        char[] separator = new char[]{'[', ' '};
        int n = this.rows.length;
        for (int i = 0; i < n; ++i) {
            separator[0] = 123;
            for (int j = 0; j <= i; ++j) {
                sb.append(separator);
                sb.append(this.rows[i][j]);
                separator[0] = 32;
            }
            sb.append('}');
            sb.append('\n');
        }
        return sb.toString();
    }

    private void transform() {
        double apq = this.rows[this.p][this.q];
        if (apq == 0.0) {
            return;
        }
        double aqq = this.rows[this.q][this.q];
        double app = this.rows[this.p][this.p];
        double arp = (aqq - app) * 0.5 / apq;
        double t = arp > 0.0 ? 1.0 / (Math.sqrt(arp * arp + 1.0) + arp) : 1.0 / (arp - Math.sqrt(arp * arp + 1.0));
        double c = 1.0 / Math.sqrt(t * t + 1.0);
        double s = t * c;
        double tau = s / (1.0 + c);
        this.rows[this.p][this.p] = app - t * apq;
        this.rows[this.q][this.q] = aqq + t * apq;
        this.rows[this.p][this.q] = 0.0;
        this.rows[this.q][this.p] = 0.0;
        int n = this.rows.length;
        for (int i = 0; i < n; ++i) {
            if (i != this.p && i != this.q) {
                this.rows[this.p][i] = this.rows[i][this.p] - s * (this.rows[i][this.q] + tau * this.rows[i][this.p]);
                this.rows[this.q][i] = this.rows[i][this.q] + s * (this.rows[i][this.p] - tau * this.rows[i][this.q]);
                this.rows[i][this.p] = this.rows[this.p][i];
                this.rows[i][this.q] = this.rows[this.q][i];
            }
            arp = this.transform[i][this.p];
            aqq = this.transform[i][this.q];
            this.transform[i][this.p] = arp - s * (aqq + tau * arp);
            this.transform[i][this.q] = aqq + s * (arp - tau * aqq);
        }
    }
}

