/*
 * Decompiled with CFR 0.152.
 */
package dr.matrix;

import dr.matrix.Matrix;

public interface MutableMatrix
extends Matrix {
    public void setDimension(int var1);

    public void setDimension(int var1, int var2);

    public void setMatrix(Matrix var1);

    public void setElements(double[][] var1);

    public void setElements(double[] var1);

    public void setElements(double var1);

    public void setElement(int var1, int var2, double var3);

    public void setElement(int var1, double var2);

    public void setRow(int var1, double[] var2);

    public void setColumn(int var1, double[] var2);

    public void setUpperTriangle(double[] var1) throws Matrix.NotSquareException;

    public void setLowerTriangle(double[] var1) throws Matrix.NotSquareException;

    public void setDiagonal(double[] var1) throws Matrix.NotSquareException;

    public void makeTransposed();

    public void makeSymmetricFromUpperTriangle() throws Matrix.NotSquareException;

    public void makeSymmetricFromLowerTriangle() throws Matrix.NotSquareException;

    public void makeIdentity() throws Matrix.NotSquareException;

    public static abstract class AbstractMutableMatrix
    extends Matrix.AbstractMatrix
    implements MutableMatrix {
        public AbstractMutableMatrix() {
        }

        public AbstractMutableMatrix(int rows) {
            this.setDimension(rows);
        }

        public AbstractMutableMatrix(int rows, int columns) {
            this.setDimension(rows, columns);
        }

        public AbstractMutableMatrix(Matrix matrix) {
            this.setDimension(matrix.getRowCount(), matrix.getColumnCount());
            this.setMatrix(matrix);
        }

        public AbstractMutableMatrix(double[][] values) {
            this.setDimension(values.length, values[0].length);
            this.setElements(values);
        }

        public AbstractMutableMatrix(int rows, int columns, double[] values) {
            this.setDimension(rows, columns);
            this.setElements(values);
        }

        public AbstractMutableMatrix(int rows, int columns, double value) {
            this.setDimension(rows, columns);
            this.setElements(value);
        }

        @Override
        public void setDimension(int rows) {
            this.setDimension(rows, rows);
        }

        @Override
        public void setMatrix(Matrix matrix) {
            int rc = matrix.getRowCount();
            int cc = matrix.getColumnCount();
            for (int r = 0; r < rc; ++r) {
                for (int c = 0; c < cc; ++c) {
                    this.setElement(r, c, matrix.getElement(r, c));
                }
            }
        }

        @Override
        public void setElements(double[][] values) {
            this.setDimension(values.length, values[0].length);
            for (int r = 0; r < values.length; ++r) {
                for (int c = 0; c < values[0].length; ++c) {
                    this.setElement(r, c, values[r][c]);
                }
            }
        }

        @Override
        public void setElements(double[] values) {
            int k = 0;
            int rc = this.getRowCount();
            int cc = this.getColumnCount();
            for (int r = 0; r < rc; ++r) {
                for (int c = 0; c < cc; ++c) {
                    this.setElement(r, c, values[k]);
                    ++k;
                }
            }
        }

        @Override
        public void setElements(double value) {
            int rc = this.getRowCount();
            int cc = this.getColumnCount();
            for (int r = 0; r < rc; ++r) {
                for (int c = 0; c < cc; ++c) {
                    this.setElement(r, c, value);
                }
            }
        }

        @Override
        public void setElement(int index, double value) {
            int r = index / this.getColumnCount();
            int c = index % this.getColumnCount();
            this.setElement(r, c, value);
        }

        @Override
        public void setRow(int row, double[] values) {
            int cc = this.getColumnCount();
            for (int c = 0; c < cc; ++c) {
                this.setElement(row, c, values[c]);
            }
        }

        @Override
        public void setColumn(int column, double[] values) {
            int rc = this.getRowCount();
            for (int r = 0; r < rc; ++r) {
                this.setElement(r, column, values[r]);
            }
        }

        @Override
        public void setUpperTriangle(double[] values) throws Matrix.NotSquareException {
            if (!this.getIsSquare()) {
                throw new Matrix.NotSquareException();
            }
            int k = 0;
            int dim = this.getRowCount();
            for (int r = 0; r < dim; ++r) {
                for (int c = r + 1; c < dim; ++c) {
                    this.setElement(r, c, values[k]);
                    ++k;
                }
            }
        }

        @Override
        public void setLowerTriangle(double[] values) throws Matrix.NotSquareException {
            if (!this.getIsSquare()) {
                throw new Matrix.NotSquareException();
            }
            int k = 0;
            int dim = this.getRowCount();
            for (int r = 0; r < dim; ++r) {
                for (int c = 0; c < r; ++c) {
                    this.setElement(r, c, values[k]);
                    ++k;
                }
            }
        }

        @Override
        public void setDiagonal(double[] values) throws Matrix.NotSquareException {
            if (!this.getIsSquare()) {
                throw new Matrix.NotSquareException();
            }
            int dim = this.getRowCount();
            for (int r = 0; r < dim; ++r) {
                this.setElement(r, r, values[r]);
            }
        }

        @Override
        public void makeTransposed() {
            double[][] values = this.getElements2D();
            int cc = this.getRowCount();
            int rc = this.getColumnCount();
            this.setDimension(rc, cc);
            for (int r = 0; r < rc; ++r) {
                for (int c = 0; c < cc; ++c) {
                    this.setElement(r, c, values[c][r]);
                }
            }
        }

        @Override
        public void makeSymmetricFromUpperTriangle() throws Matrix.NotSquareException {
            if (!this.getIsSquare()) {
                throw new Matrix.NotSquareException();
            }
            double[] values = this.getUpperTriangle();
            this.setLowerTriangle(values);
        }

        @Override
        public void makeSymmetricFromLowerTriangle() throws Matrix.NotSquareException {
            if (!this.getIsSquare()) {
                throw new Matrix.NotSquareException();
            }
            double[] values = this.getUpperTriangle();
            this.setLowerTriangle(values);
        }

        @Override
        public void makeIdentity() throws Matrix.NotSquareException {
            if (!this.getIsSquare()) {
                throw new Matrix.NotSquareException();
            }
            this.setElements(0.0);
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setElement(i, i, 1.0);
            }
        }
    }
}

