/*
 * Decompiled with CFR 0.152.
 */
package dr.stats;

import dr.stats.DiscreteStatistics;
import java.util.ArrayList;
import java.util.List;

public interface Variate<T> {
    public int getCount();

    public T get(int var1);

    public T getMin();

    public T getMax();

    public T getRange();

    public T getSum();

    public T getMean();

    public double getQuantile(T var1);

    public void add(T var1);

    public void add(Variate var1);

    public void add(T[] var1);

    public void remove(int var1);

    public void removeAll();

    public static class I
    extends N<Integer> {
        public I() {
        }

        public I(List<Integer> values) {
            this.add(values);
        }

        public I(Integer[] values) {
            this.add((Number[])values);
        }

        @Override
        public Integer getMin() {
            Integer minValue = Integer.MAX_VALUE;
            for (Integer value : this.values) {
                if (value >= minValue) continue;
                minValue = value;
            }
            return minValue;
        }

        @Override
        public Integer getMax() {
            Integer maxValue = Integer.MIN_VALUE;
            for (Integer value : this.values) {
                if (value <= maxValue) continue;
                maxValue = value;
            }
            return maxValue;
        }

        @Override
        public Integer getRange() {
            return this.getMin() - this.getMax();
        }

        @Override
        public Integer getMean() {
            return this.getSum() / this.getCount();
        }

        @Override
        public Integer getSum() {
            Integer sum = 0;
            for (Integer value : this.values) {
                sum = sum + value;
            }
            return sum;
        }

        @Override
        public double getQuantile(Integer q) {
            double[] dv = new double[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                dv[i] = ((Integer)this.values.get(i)).doubleValue();
            }
            return DiscreteStatistics.quantile(q.doubleValue(), dv);
        }
    }

    public static class D
    extends N<Double> {
        public D() {
        }

        public D(List<Double> values) {
            this.add(values);
        }

        public D(Double[] values) {
            this.add((Number[])values);
        }

        @Override
        public Double getMin() {
            Double minValue = Double.POSITIVE_INFINITY;
            for (Double value : this.values) {
                if (!(value < minValue)) continue;
                minValue = value;
            }
            return minValue;
        }

        @Override
        public Double getMax() {
            Double maxValue = Double.NEGATIVE_INFINITY;
            for (Double value : this.values) {
                if (!(value > maxValue)) continue;
                maxValue = value;
            }
            return maxValue;
        }

        @Override
        public Double getRange() {
            return this.getMin() - this.getMax();
        }

        @Override
        public Double getMean() {
            return this.getSum() / (double)this.getCount();
        }

        @Override
        public Double getSum() {
            Double sum = 0.0;
            for (Double value : this.values) {
                sum = sum + value;
            }
            return sum;
        }

        @Override
        public double getQuantile(Double q) {
            double[] dv = new double[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                dv[i] = (Double)this.values.get(i);
            }
            return DiscreteStatistics.quantile(q, dv);
        }
    }

    public static abstract class N<Number>
    implements Variate<Number> {
        protected List<Number> values = new ArrayList<Number>();

        @Override
        public int getCount() {
            return this.values.size();
        }

        @Override
        public void add(Variate values) {
            for (int i = 0; i < values.getCount(); ++i) {
                this.add((Number)values.get(i));
            }
        }

        @Override
        public void add(Number value) {
            this.values.add(value);
        }

        @Override
        public Number get(int index) {
            return this.values.get(index);
        }

        @Override
        public void remove(int index) {
            this.values.remove(index);
        }

        @Override
        public void removeAll() {
            this.values.clear();
        }

        @Override
        public void add(List<Number> values) {
            this.values.addAll(values);
        }

        @Override
        public void add(Number[] values) {
            for (Number value : values) {
                this.add(value);
            }
        }
    }
}

