/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;

public class FileHelpers {
    public static final String FILE_NAME = "fileName";
    private static File masterDirectory = null;

    public static int numberOfLines(File file) throws IOException {
        RandomAccessFile randFile = new RandomAccessFile(file, "r");
        long lastRec = randFile.length();
        randFile.close();
        FileReader fileRead = new FileReader(file);
        LineNumberReader lineRead = new LineNumberReader(fileRead);
        lineRead.skip(lastRec);
        int count = lineRead.getLineNumber() - 1;
        fileRead.close();
        lineRead.close();
        return count;
    }

    public static File getFile(String fileName, String prefix) {
        boolean relative;
        boolean localFile = fileName.startsWith("./");
        boolean bl = relative = masterDirectory != null && localFile;
        if (localFile) {
            fileName = fileName.substring(2);
        }
        if (prefix != null) {
            fileName = prefix + fileName;
        }
        File file = new File(fileName);
        String name = file.getName();
        String parent = file.getParent();
        if (!file.isAbsolute()) {
            String p = relative ? masterDirectory.getAbsolutePath() : System.getProperty("user.dir");
            parent = parent != null && parent.length() > 0 ? p + '/' + parent : p;
        }
        return new File(parent, name);
    }

    public static File getFile(String fileName) {
        return FileHelpers.getFile(fileName, null);
    }

    public static void setMasterDir(File fileName) {
        masterDirectory = fileName;
    }
}

