/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class MessageLogHandler
extends StreamHandler {
    public MessageLogHandler() {
        this.setOutputStream(System.out);
        this.setFormatter(new MessageLogFormatter());
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }

    @Override
    public void close() {
        this.flush();
    }

    private class MessageLogFormatter
    extends Formatter {
        private final String lineSeparator = System.getProperty("line.separator");

        private MessageLogFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.formatMessage(record));
            sb.append(this.lineSeparator);
            return sb.toString();
        }
    }
}

