/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.io.Serializable;
import java.text.DecimalFormat;

public class NumberFormatter
implements Serializable {
    private int sf;
    private double upperCutoff;
    private double[] cutoffTable;
    private final DecimalFormat decimalFormat = new DecimalFormat();
    private DecimalFormat scientificFormat = null;
    private boolean isPadding = false;
    private int fieldWidth;

    public NumberFormatter(int sf) {
        this.setSignificantFigures(sf);
    }

    public NumberFormatter(int sf, int fieldWidth) {
        this.setSignificantFigures(sf);
        this.setPadding(true);
        this.setFieldWidth(fieldWidth);
    }

    public void setSignificantFigures(int sf) {
        this.sf = sf;
        this.upperCutoff = Math.pow(10.0, sf - 1);
        this.cutoffTable = new double[sf];
        long num = 10L;
        for (int i = 0; i < this.cutoffTable.length; ++i) {
            this.cutoffTable[i] = num;
            num *= 10L;
        }
        this.decimalFormat.setMinimumIntegerDigits(1);
        this.decimalFormat.setMaximumFractionDigits(sf - 1);
        this.decimalFormat.setMinimumFractionDigits(sf - 1);
        this.decimalFormat.setGroupingUsed(false);
        this.scientificFormat = new DecimalFormat(this.getScientificPattern(sf));
        this.fieldWidth = sf;
    }

    public void setPadding(boolean padding) {
        this.isPadding = padding;
    }

    public void setFieldWidth(int fw) {
        if (fw < this.sf + 4) {
            throw new IllegalArgumentException();
        }
        this.fieldWidth = fw;
    }

    public int getFieldWidth() {
        return this.fieldWidth;
    }

    public String formatToFieldWidth(String s, int fieldWidth) {
        int size = fieldWidth - s.length();
        StringBuffer buffer = new StringBuffer(s);
        for (int i = 0; i < size; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public String formatDecimal(double value, int numFractionDigits) {
        this.decimalFormat.setMaximumFractionDigits(numFractionDigits);
        this.decimalFormat.setMinimumFractionDigits(Math.min(numFractionDigits, 1));
        return this.decimalFormat.format(value);
    }

    public String format(double value) {
        StringBuffer buffer = new StringBuffer();
        double absValue = Math.abs(value);
        if (absValue > this.upperCutoff || absValue < 0.1 && absValue != 0.0) {
            buffer.append(this.scientificFormat.format(value));
        } else {
            int numFractionDigits = 0;
            if (value != (double)((int)value)) {
                numFractionDigits = this.getNumFractionDigits(value);
            }
            buffer.append(this.formatDecimal(value, numFractionDigits));
        }
        if (this.isPadding) {
            int size = this.fieldWidth - buffer.length();
            for (int i = 0; i < size; ++i) {
                buffer.append(' ');
            }
        }
        return buffer.toString();
    }

    private int getNumFractionDigits(double value) {
        value = Math.abs(value);
        for (int i = 0; i < this.cutoffTable.length; ++i) {
            if (!(value < this.cutoffTable[i])) continue;
            return this.sf - i - 1;
        }
        return this.sf - 1;
    }

    private String getScientificPattern(int sf) {
        String pattern = "0.";
        for (int i = 0; i < sf - 1; ++i) {
            pattern = pattern + "#";
        }
        pattern = pattern + "E0";
        return pattern;
    }
}

