/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Permutator
implements Iterator {
    private final int size;
    private final Object[] elements;
    private final Object ar;
    private final int[] permutation;
    private boolean next = true;

    public Permutator(Object[] e) {
        this.size = e.length;
        this.elements = new Object[this.size];
        System.arraycopy(e, 0, this.elements, 0, this.size);
        this.ar = Array.newInstance(e.getClass().getComponentType(), this.size);
        System.arraycopy(e, 0, this.ar, 0, this.size);
        this.permutation = new int[this.size + 1];
        for (int i = 0; i < this.size + 1; ++i) {
            this.permutation[i] = i;
        }
    }

    private void formNextPermutation() {
        for (int i = 0; i < this.size; ++i) {
            Array.set(this.ar, i, this.elements[this.permutation[i + 1] - 1]);
        }
    }

    @Override
    public boolean hasNext() {
        return this.next;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private void swap(int i, int j) {
        int x = this.permutation[i];
        this.permutation[i] = this.permutation[j];
        this.permutation[j] = x;
    }

    public Object next() throws NoSuchElementException {
        this.formNextPermutation();
        int i = this.size - 1;
        while (this.permutation[i] > this.permutation[i + 1]) {
            --i;
        }
        if (i == 0) {
            this.next = false;
            for (int j = 0; j < this.size + 1; ++j) {
                this.permutation[j] = j;
            }
            return this.ar;
        }
        int j = this.size;
        while (this.permutation[i] > this.permutation[j]) {
            --j;
        }
        this.swap(i, j);
        int r = this.size;
        for (int s = i + 1; r > s; --r, ++s) {
            this.swap(r, s);
        }
        return this.ar;
    }

    public String toString() {
        int n = Array.getLength(this.ar);
        StringBuffer sb = new StringBuffer("[");
        for (int j = 0; j < n; ++j) {
            sb.append(Array.get(this.ar, j).toString());
            if (j >= n - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return new String(sb);
    }

    public static void main(String[] args) {
        Permutator i = new Permutator(args);
        while (i.hasNext()) {
            i.next();
            System.out.println(i);
        }
    }
}

