/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.Attribute;
import java.lang.reflect.Method;

public class Property
implements Attribute {
    private Object object = null;
    private Method getter = null;
    private Object argument = null;
    private String name = null;

    public Property(Object object, String name) {
        this(object, name, null);
    }

    public Property(Object object, String name, Object argument) {
        this.name = name;
        this.argument = argument;
        this.object = object;
        StringBuffer getterName = new StringBuffer("get");
        getterName.append(name.substring(0, 1).toUpperCase());
        getterName.append(name.substring(1));
        Class<?> c = object.getClass();
        try {
            this.getter = argument != null ? c.getMethod(getterName.toString(), argument.getClass()) : c.getMethod(getterName.toString(), null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public Method getGetter() {
        return this.getter;
    }

    @Override
    public String getAttributeName() {
        if (this.argument == null) {
            return this.name;
        }
        return this.name + "." + this.argument;
    }

    public Object getAttributeValue() {
        if (this.object == null || this.getter == null) {
            return null;
        }
        Object result = null;
        Object[] args = null;
        if (this.argument != null) {
            args = new Object[]{this.argument};
        }
        try {
            result = this.getter.invoke(this.object, args);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    public String getPropertyName() {
        return this.name;
    }

    public String toString() {
        return this.getAttributeValue().toString();
    }
}

