/*
 * Decompiled with CFR 0.152.
 */
package emc;

import emc.EntangledStatistics;
import emc.SimulateEMC;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import java.util.Random;
import monaco.process.ProcessSchedule;
import nuts.io.IO;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;

public class CoalescentSimulation
implements Runnable {
    @Option(required=true)
    public int K;
    @Option(required=true)
    public int M;
    @Option(required=true)
    public int Km;
    @Option(required=true)
    public int R;
    @Option(required=true)
    public Random seed1 = new Random(1L);
    @Option(required=true)
    public Random seed2 = new Random(1L);
    @Option(required=true)
    public int numSamples;
    @Option(required=false)
    public int numSimulations = 0;
    @Option(required=true)
    public SimulateEMC.Allocation allocation;
    private ParticleKernel<EqualWeightParticle> kernel;
    private ParticleFilter.ParticleProcessor<EqualWeightParticle> processor;
    private ProcessSchedule schedule = null;

    @Override
    public void run() {
        EntangledStatistics.CoalescentStatistics stat;
        SimulateEMC.scheme = this.allocation;
        if (this.numSimulations == 0) {
            boolean done = false;
            block0: while (!done) {
                ++this.numSimulations;
                LogInfo.logs("------------------Simulation no. " + this.numSimulations + "------------------");
                this.simulate(this.seed1.nextInt(), this.seed2.nextInt());
                done = true;
                for (long r = 1L; r < (long)this.R; ++r) {
                    stat = EntangledStatistics.getEntangledStatistics().getCoalescentStat(r);
                    if (stat.getNumSamples() >= this.numSamples) continue;
                    done = false;
                    LogInfo.logs("r=" + r + ": " + stat.getNumSamples() + "/" + this.numSamples);
                    continue block0;
                }
            }
        } else {
            for (int n = 0; n < this.numSimulations; ++n) {
                LogInfo.logs("------------------Simulation no. " + (n + 1) + "------------------");
                this.simulate(this.seed1.nextInt(), this.seed2.nextInt());
            }
        }
        LogInfo.logs("generation avg stdev samples");
        for (long r = 0L; r < (long)this.R; ++r) {
            StringBuilder sb = new StringBuilder();
            stat = EntangledStatistics.getEntangledStatistics().getCoalescentStat(r);
            double avg = 0.0;
            double sampleSize = 0.0;
            double stdev = 0.0;
            if (stat != null) {
                avg = stat.getMean();
                sampleSize = stat.getNumSamples();
                stdev = stat.getStdev() / Math.sqrt(sampleSize + 0.0);
            }
            sb.append(r + " ");
            sb.append(avg + " ");
            sb.append(stdev + " ");
            sb.append(sampleSize);
            LogInfo.logs(sb.toString());
        }
        Pair<Double, Integer> reconstructionStat = EntangledStatistics.getEntangledStatistics().getReconstructionStat();
        double totalReconstructions = reconstructionStat.getFirst();
        double avgReconstruction = totalReconstructions / (double)this.numSimulations;
        double ratio = 1.0 + avgReconstruction / (double)(this.R * this.K);
        LogInfo.logs("avg # of maps applied by EMC=" + ((double)(this.R * this.K) + avgReconstruction));
        LogInfo.logs("avg # of maps applied by SMC=" + this.R * this.K);
        LogInfo.logs("the ratio of # of maps applied (EMC/SMC)=" + ratio);
    }

    private void simulate(int seed1, int seed2) {
        this.kernel = new CoalescentKernel(this.R, this.K);
        this.processor = new CoalescentProcessor<EqualWeightParticle>(this.kernel, this.R);
        SimulateEMC<EqualWeightParticle> emc = new SimulateEMC<EqualWeightParticle>(this.K, this.M, this.Km, seed1, seed2, this.kernel, this.processor, this.schedule);
        for (int r = 0; r < this.R; ++r) {
            emc.propagate();
            emc.resampleAndAllocate();
        }
    }

    public static void main(String[] args) {
        IO.run(args, new CoalescentSimulation());
    }

    public static class EqualWeightParticle {
        public int id;
        public int r;
        public EqualWeightParticle parent;

        public EqualWeightParticle(int r, EqualWeightParticle parent) {
            this.r = r;
            this.parent = parent;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String toString() {
            return "(" + this.r + ", " + this.id + ")";
        }
    }

    public static class CoalescentKernel
    implements ParticleKernel<EqualWeightParticle> {
        public int R;
        public double W;
        public EqualWeightParticle initial;

        public CoalescentKernel(int R, int K) {
            this.R = R;
            this.W = Math.log(1.0 / (double)K);
            this.initial = new EqualWeightParticle(0, null);
        }

        @Override
        public Pair<EqualWeightParticle, Double> next(Random rand, EqualWeightParticle current) {
            EqualWeightParticle newParticle = new EqualWeightParticle(current.r + 1, current);
            double w = this.W;
            return new Pair<EqualWeightParticle, Double>(newParticle, w);
        }

        @Override
        public int nIterationsLeft(EqualWeightParticle partialState) {
            return this.R - partialState.r;
        }

        @Override
        public EqualWeightParticle getInitial() {
            return this.initial;
        }
    }

    public static class CoalescentProcessor<T>
    implements ParticleFilter.ParticleProcessor<T> {
        ParticleKernel<T> kernel;
        int R;

        public CoalescentProcessor(ParticleKernel<T> kernel, int R) {
            this.kernel = kernel;
            this.R = R;
        }

        @Override
        public void process(T state, double weight) {
            if (this.kernel.nIterationsLeft(state) != this.R) {
                throw new RuntimeException();
            }
        }
    }
}

