/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import ev.ex.DataGenerator;
import ev.poi.processors.TreeDistancesProcessor;
import fig.basic.LogInfo;
import java.io.File;
import java.util.List;
import ma.SequenceType;
import nuts.io.IO;
import pty.io.Dataset;
import pty.smc.LazyParticleFilter;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleKernel;
import pty.smc.PriorPriorKernel;
import pty.smc.models.CTMC;

public class GetPhylogeneticKernel
implements Runnable {
    public static DataGenerator.DataGeneratorMain generator = new DataGenerator.DataGeneratorMain();
    private static boolean generated = false;
    private static File dataFile = null;

    public static ParticleKernel<PartialCoalescentState> getPhyloKernel() {
        GetPhylogeneticKernel.generateData();
        Dataset dataset = Dataset.DatasetUtils.fromAlignment(dataFile, SequenceType.RNA);
        CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
        PartialCoalescentState init = PartialCoalescentState.initFastState(dataset, ctmc);
        return new PriorPriorKernel(init);
    }

    public static ParticleKernel<PartialCoalescentState> getPhyloKernel(int nTaxa, int len) {
        GetPhylogeneticKernel.generator.nTaxa = nTaxa;
        GetPhylogeneticKernel.generator.len = len;
        GetPhylogeneticKernel.generateData();
        Dataset dataset = Dataset.DatasetUtils.fromAlignment(dataFile, SequenceType.RNA);
        CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
        PartialCoalescentState init = PartialCoalescentState.initFastState(dataset, ctmc);
        return new PriorPriorKernel(init);
    }

    public static ParticleKernel<PartialCoalescentState> getPhyloKernel(int nTaxa, String fileloc) {
        GetPhylogeneticKernel.generator.useGutellData = true;
        GetPhylogeneticKernel.generator.useFullGutellLocFile = false;
        GetPhylogeneticKernel.generator.gutellLocation = new File(fileloc);
        GetPhylogeneticKernel.generator.nTaxa = nTaxa;
        GetPhylogeneticKernel.generator.len = Integer.MAX_VALUE;
        GetPhylogeneticKernel.generateData();
        Dataset dataset = Dataset.DatasetUtils.fromAlignment(dataFile, SequenceType.RNA);
        CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
        PartialCoalescentState init = PartialCoalescentState.initFastState(dataset, ctmc);
        return new PriorPriorKernel(init);
    }

    private static void generateData() {
        if (generated) {
            return;
        }
        generator.run();
        List<File> fs = IO.ls(GetPhylogeneticKernel.generator.output, "msf");
        dataFile = fs.get(0);
        generated = true;
    }

    public static void main(String[] args) {
        IO.run(args, new GetPhylogeneticKernel(), "dataGenerator", generator);
    }

    @Override
    public void run() {
        ParticleKernel<PartialCoalescentState> pk2 = GetPhylogeneticKernel.getPhyloKernel();
        LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
        LazyParticleFilter.Eager2LazyAdaptor<PartialCoalescentState> adaptor = new LazyParticleFilter.Eager2LazyAdaptor<PartialCoalescentState>(pk2);
        LazyParticleFilter<PartialCoalescentState> lpf = new LazyParticleFilter<PartialCoalescentState>(adaptor, options);
        TreeDistancesProcessor tdp = new TreeDistancesProcessor();
        double zHat = lpf.sample(tdp);
        LogInfo.logsForce("Norm:" + zHat);
    }
}

