/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import ev.Test;
import ev.ex.PairAlign;
import ev.hmm.HetPairHMM;
import ev.multi.MessageComputations;
import ev.par.ExponentialFamily;
import ev.par.FeatureExtractor;
import ev.poi.exp.MSAOutput;
import ev.poi.exp.PhylogeneticOutput;
import goblin.Taxon;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ma.GreedyDecoder;
import ma.MSAParser;
import ma.MSAPoset;
import ma.MultiAlignment;
import nuts.io.IO;
import nuts.maxent.MaxentClassifier;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.IncrementalExperiment;

public class MFSystem
implements IncrementalExperiment.ReestimatedSystem,
IncrementalExperiment.Parallelizable {
    public static ExponentialFamily.ExponentialFamilyOptions expFamOptions = new ExponentialFamily.ExponentialFamilyOptions();
    public static FeatureExtractor.FeatureOptions featureOptions = new FeatureExtractor.FeatureOptions();
    public static MaxentClassifier.MaxentOptions<Object> learningOptions = new MaxentClassifier.MaxentOptions();
    private ExponentialFamily _expFam = null;
    private Map<File, MessageComputations.QMessages> qMessages = CollUtils.map();

    public ExponentialFamily getModel() {
        if (this._expFam == null) {
            this._expFam = ExponentialFamily.createExpfam(learningOptions, expFamOptions, featureOptions, null);
        }
        return this._expFam;
    }

    public static void main(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        MFSystem system = new MFSystem();
        IncrementalExperiment experiments = new IncrementalExperiment(system);
        experiments.outputTypeClassPackage = PhylogeneticOutput.class.getPackage().getName();
        IO.run(args, experiments, "anno", MessageComputations.class, "expFam", expFamOptions, "feat", featureOptions, "learn", learningOptions, "system", system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inference(IncrementalExperiment.InferenceContext context) {
        ExponentialFamily expFam = this.getModel();
        MultiAlignment msa = PairAlign.PairAlignMain.fixMSA(expFam.model.enc, MSAParser.parseMSA(context.getInput()).toMultiAlignmentObject());
        MessageComputations.QMessages previousQs = null;
        MFSystem mFSystem = this;
        synchronized (mFSystem) {
            previousQs = this.qMessages.get(context.getInput());
        }
        Counter<GreedyDecoder.Edge> edgePosteriors = new Counter<GreedyDecoder.Edge>();
        MessageComputations.QMessages newQs = MessageComputations.blank(msa);
        List<MultiAlignment> pairs = Test.extractPairwiseAlignments(msa, false);
        for (MultiAlignment pairAlign : pairs) {
            Taxon l1 = pairAlign.nodes().get(0);
            Taxon l2 = pairAlign.nodes().get(1);
            String s1 = pairAlign.getSequences().get(l1);
            String s2 = pairAlign.getSequences().get(l2);
            double[][][] rMessages = previousQs == null ? MessageComputations.initRMessages(s1.length(), s2.length()) : MessageComputations.rMessages(l1, l2, previousQs);
            HetPairHMM hmm = expFam.getReweightedHMM(rMessages, s1, s2, l1, l2);
            MessageComputations.qMessages(hmm, newQs, l1, l2, rMessages);
            Taxon botLang = l2;
            Taxon topLang = l1;
            for (int botPos = 0; botPos < s2.length(); ++botPos) {
                for (int topPos = 0; topPos < s1.length(); ++topPos) {
                    edgePosteriors.setCount(new GreedyDecoder.Edge(topPos, botPos, topLang, botLang), Math.exp(hmm.logPosteriorAlignment(topPos, botPos)));
                }
            }
        }
        MFSystem mFSystem2 = this;
        synchronized (mFSystem2) {
            this.qMessages.put(context.getInput(), newQs);
        }
        File msaFile = context.getMainOutputFile(MSAOutput.MSA_OUTPUT);
        MSAPoset.maxRecallMSA(msa.getSequences(), edgePosteriors).toMultiAlignmentObject().saveToMSF(msaFile);
        File msaFileCons = context.getOutputFile(MSAOutput.MSA_OUTPUT, "consensus");
        MFSystem.getConsensusMSA(msa.getSequences(), edgePosteriors, 0.5).toMultiAlignmentObject().saveToMSF(msaFileCons);
    }

    public static MSAPoset getConsensusMSA(Map<Taxon, String> sequences, Counter<GreedyDecoder.Edge> edgePosteriors, double threshold) {
        if (threshold < 0.0 || threshold > 1.0) {
            throw new RuntimeException();
        }
        Counter<GreedyDecoder.Edge> filtered = new Counter<GreedyDecoder.Edge>();
        for (GreedyDecoder.Edge e : edgePosteriors.keySet()) {
            if (!(edgePosteriors.getCount(e) >= threshold)) continue;
            filtered.setCount(e, edgePosteriors.getCount(e));
        }
        return MSAPoset.maxRecallMSA(sequences, filtered);
    }

    @Override
    public boolean estimation(IncrementalExperiment.EstimationContext context) {
        return true;
    }

    @Override
    public String name() {
        return "MFBP";
    }

    @Override
    public Map<IncrementalExperiment.OutputType, IncrementalExperiment.System> requiredInferenceInitializers() {
        HashMap<IncrementalExperiment.OutputType, IncrementalExperiment.System> result = CollUtils.map();
        return result;
    }
}

