/*
 * Decompiled with CFR 0.152.
 */
package ev.poi;

import nuts.maxent.SloppyMath;
import nuts.util.MathUtils;

public class PoissonUtils {
    public static double logPhi(double logQ, int N2, double lambda) {
        if (logQ >= 0.0) {
            throw new RuntimeException();
        }
        if (lambda <= 0.0) {
            throw new RuntimeException();
        }
        if (N2 < 0) {
            throw new RuntimeException();
        }
        double logLambda = Math.log(lambda);
        double sum = Double.NEGATIVE_INFINITY;
        for (int n = N2; n < N2 + 1000000; ++n) {
            double prevSum = sum;
            if (prevSum != (sum = SloppyMath.logAdd(sum, (double)n * logLambda + (double)(n - N2) * logQ - MathUtils.logFactorial(n)))) continue;
            return sum - lambda;
        }
        throw new RuntimeException("Did not converge!");
    }

    public static double dlogPhi_dLambda(double logQ, int N2, double lambda) {
        return Math.exp(PoissonUtils.logPhi(logQ, N2 - 1, lambda) - PoissonUtils.logPhi(logQ, N2, lambda)) - 1.0;
    }

    public static double poissonLogPr(int n, double mean) {
        if (mean <= 0.0) {
            throw new RuntimeException();
        }
        if (n < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return (double)n * Math.log(mean) - mean - MathUtils.logFactorial(n);
    }

    public static void main(String[] args) {
        double lambda = 25.0;
        final double logQ = Math.log(0.01);
        int N2 = 100;
        MathUtils.FPlusDelta fpd = new MathUtils.FPlusDelta(){

            @Override
            public double logfd(double delta) {
                return PoissonUtils.logPhi(logQ, 100, 25.0 + delta);
            }
        };
        System.out.println("Analytic:" + PoissonUtils.dlogPhi_dLambda(logQ, 100, 25.0));
        System.out.println("log_N:" + PoissonUtils.logPhi(logQ, 100, 25.0));
        System.out.println("log_N-1:" + PoissonUtils.logPhi(logQ, 99, 25.0));
        MathUtils.approxDirDeriv(fpd, 0.01, 10);
        System.out.println("--");
        for (double mean = 1.0; mean < 500.0; mean += 0.5) {
            System.out.println("" + mean + "\t" + PoissonUtils.logPhi(logQ, 100, mean));
        }
    }
}

