/*
 * Decompiled with CFR 0.152.
 */
package ev.poi.processors;

import conifer.Phylogeny;
import conifer.particle.PhyloParticle;
import ev.ex.NJPState;
import fig.basic.LogInfo;
import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.io.Serializable;
import java.util.Set;
import nuts.util.Counter;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.smc.LazyPCS;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;

public class TreeTopologyProcessor
implements ParticleFilter.ParticleProcessor,
Serializable {
    private static final long serialVersionUID = 1L;
    private Counter<UnrootedTree> urtCounter = new Counter();
    private double bestLogLikelihood = Double.NEGATIVE_INFINITY;
    private Phylogeny best = null;
    private double norm = 0.0;

    public Counter<UnrootedTree> getUrtCounter() {
        Counter<UnrootedTree> result = new Counter<UnrootedTree>();
        for (UnrootedTree key : this.urtCounter.keySet()) {
            result.setCount(key, this.urtCounter.getCount(key) / this.norm);
        }
        return result;
    }

    public Phylogeny getMode() {
        return this.best;
    }

    public double getBestLogLikelihood() {
        return this.bestLogLikelihood;
    }

    public void process(Object state, double weight) {
        if (state instanceof LazyPCS) {
            state = ((LazyPCS)state).getState();
        }
        if (state instanceof PartialCoalescentState) {
            this.process(UnrootedTree.fromRooted(((PartialCoalescentState)state).getFullCoalescentState()), weight);
            double currentLogLL = ((PartialCoalescentState)state).logLikelihood();
            if (currentLogLL > this.bestLogLikelihood) {
                this.best = ((PartialCoalescentState)state).getFullCoalescentState();
                this.bestLogLikelihood = currentLogLL;
            }
        } else if (state instanceof PhyloParticle) {
            PhyloParticle pp = (PhyloParticle)state;
            this.process(pp.getPhylogeny().getUnrooted(), weight);
            double currentLogLL = pp.getLogLikelihood();
            if (currentLogLL > this.bestLogLikelihood) {
                LogInfo.logsForce("better LL found: " + this.bestLogLikelihood + " -> [ ll(" + currentLogLL + ") + lp(" + pp.getLogPrior() + ") = " + (currentLogLL + pp.getLogPrior()) + " ]");
                LogInfo.logsForce("ll" + currentLogLL);
                this.best = pp.getPhylogeny();
                this.bestLogLikelihood = currentLogLL;
            }
        } else if (state instanceof NJPState) {
            this.process(((NJPState)state).pcs, weight);
        } else {
            throw new RuntimeException();
        }
    }

    public void process(UnrootedTree t, double w) {
        this.norm += w;
        this._process(t, w);
    }

    public void process(RootedTree rt) {
        this.process(UnrootedTree.fromRooted(rt));
    }

    public void process(UnrootedTree t) {
        this.norm += 1.0;
        this._process(t, 1.0);
    }

    private void _process(UnrootedTree ut, double w) {
        Set<Set<Taxon>> cladeSets = ut.unRootedClades();
        boolean newadd = true;
        for (UnrootedTree urt : this.urtCounter.keySet()) {
            if (!cladeSets.equals(urt.unRootedClades())) continue;
            this.urtCounter.incrementCount(urt, w);
            newadd = false;
            break;
        }
        if (newadd) {
            UnrootedTree urtNoBranch = new UnrootedTree(ut);
            for (UnorderedPair<Taxon, Taxon> edge : ut.edges()) {
                urtNoBranch.changeBranchLength(edge, 1.0);
            }
            this.urtCounter.incrementCount(urtNoBranch, w);
        }
    }
}

