/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import ev.to.NexusWriter;
import fig.basic.IOUtils;
import fig.basic.Option;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ma.MSAParser;
import ma.MSAPoset;
import ma.RateMatrixLoader;
import ma.SequenceType;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.util.CollUtils;
import pty.RootedTree;

public class MrBayes
implements Runnable {
    public static final MrBayes instance = new MrBayes();
    @Option
    public String mrBayesPath = "mb";
    @Option
    public int nMCMCIters = 10000;
    @Option
    public int nChains = 1;
    @Option
    public int seed = 1297732343;
    @Option
    public String treePrior = "clock:coalescence";
    @Option
    public double mbRate = 1.0;
    @Option
    public boolean setToK2P = true;
    @Option
    public boolean setFixCoalescentPr = true;
    @Option
    public boolean fixTopo = false;
    @Option
    public boolean use3_2_2 = false;
    @Option
    public SequenceType st = SequenceType.RNA;
    @Option
    public File alignmentInputFile = null;
    private File workingDir = null;
    @Option(gloss="Path to starting tree file or empty for random start")
    public String startingTree = "";
    public static final String NEX_FILE = "data.nex";
    private final Pattern translPattern = Pattern.compile("\\s*([0-9]+)\\s(.*)[,;]");
    public double b4 = RateMatrixLoader.beta(RateMatrixLoader.DEFAULT_TRANS2TRANV) * 4.0;
    public double a4 = RateMatrixLoader.alpha(RateMatrixLoader.DEFAULT_TRANS2TRANV) * 4.0;

    public File computeSamples(MSAPoset alignment, SequenceType st) {
        this.workingDir = IO.getTempDir("temp-mrbayes");
        File nexusFile = new File(this.workingDir, NEX_FILE);
        File mrBayesCmd = new File(this.workingDir, "mrbayes.cmd");
        NexusWriter.writeNexus(alignment, nexusFile, st, this.startingTree);
        this.writeMrBayesCmd(mrBayesCmd);
        String msg = IO.call("" + this.mrBayesPath + " " + mrBayesCmd.getName(), null, this.workingDir);
        IO.writeToDisk(new File(this.workingDir, "mrbayes-stdout"), msg);
        return this.workingDir;
    }

    public void processMrBayesTrees(RootedTree.RootedTreeProcessor rtp) {
        this.processMrBayesTrees(rtp, 1);
    }

    public void cleanUpMrBayesOutput() {
        for (File f : IO.ls(this.workingDir)) {
            f.delete();
        }
        this.workingDir.delete();
    }

    public void processMrBayesTrees(RootedTree.RootedTreeProcessor rtp, int runNumber) {
        this.processMrBayesTrees(new File(this.workingDir, "data.nex.run" + runNumber + ".t"), rtp);
    }

    public void processMrBayesTrees(File file, RootedTree.RootedTreeProcessor rtp) {
        Map<String, String> translation = this.translation(file);
        for (String line : IO.i(file)) {
            if (!line.matches("^\\s*tree (rep|gen).*")) continue;
            rtp.process(this.parseTree(line, translation));
        }
    }

    private Map<String, String> translation(File file) {
        HashMap<String, String> trans = CollUtils.map();
        for (String line : IO.i(file)) {
            if (this.newickPattern().matcher(line).matches()) break;
            if (!this.translPattern.matcher(line).matches()) continue;
            List<String> matches = StringUtils.multiSelectFirstRegex(this.translPattern, line);
            trans.put(matches.get(0), matches.get(1));
        }
        return trans;
    }

    private final Pattern newickPattern() {
        return Pattern.compile(".*[=]" + (this.use3_2_2 ? "\\s\\[..\\]" : "") + "\\s(.*)[;]");
    }

    private RootedTree parseTree(String line, Map<String, String> translation) {
        String newickStr = StringUtils.selectFirstRegex(this.newickPattern(), line);
        for (String code : translation.keySet()) {
            String codeCtx = StringUtils.selectFirstRegex("([,)(])" + code + "[:]", newickStr);
            newickStr = newickStr.replace(codeCtx + code + ":", codeCtx + translation.get(code) + ":");
        }
        newickStr = newickStr + ";";
        return RootedTree.Util.fromNewickString(newickStr);
    }

    private void writeMrBayesCmd(File mrBayesCmd) {
        PrintWriter out = IOUtils.openOutEasy(mrBayesCmd);
        out.append("begin mrbayes;\n" + (this.use3_2_2 ? "set seed=" + this.seed + ";\n" : "") + "set autoclose=yes nowarn=yes;\nexecute " + NEX_FILE + ";\nprset brlenspr=" + this.treePrior + (this.mbRate == 1.0 ? "" : "(" + this.mbRate + ")") + ";\n" + (this.setFixCoalescentPr ? "prset thetapr=fixed(1.0);\n" : "") + "mcmcp ngen=" + this.nMCMCIters + ";\nmcmcp Nchains=" + this.nChains + ";\n" + (this.fixTopo ? "prset topologypr = fixed(mystarttree);\n" : "") + (this.use3_2_2 ? "" : "mcmcp seed=" + Math.abs(this.seed) + ";\n") + (this.setToK2P ? "lset nst=6;\nprset statefreqpr=fixed(0.25,0.25,0.25,0.25);\nprset revmatpr=fixed(" + this.b4 + "," + this.a4 + "," + this.b4 + "," + this.b4 + "," + this.a4 + "," + this.b4 + ");\n" : "") + "mcmc;\nsumt;\nend;\n");
        out.close();
    }

    public static void main(String[] args) {
        IO.run(args, new MrBayes());
    }

    @Override
    public void run() {
        MSAPoset align = MSAParser.parseMSA(this.alignmentInputFile);
        this.computeSamples(align, this.st);
        this.processMrBayesTrees(new RootedTree.RootedTreeProcessor(){

            @Override
            public void process(RootedTree rt) {
                System.out.println(rt);
            }
        });
    }
}

