/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import ev.to.PhyloTools;
import fig.basic.Option;
import java.io.File;
import nuts.io.IO;

public class PhyML
extends PhyloTools {
    @Option
    public String phymlPath = "phyml_macintel";
    @Option(gloss="0 for dna, 1 for aa")
    public int data_type = 0;
    @Option
    public String format = "i";
    @Option
    public int data_sets = 1;
    @Option
    public int bootstrap_sets = 1;
    @Option
    public String model = "HKY";
    @Option
    public double kappa = 4.0;
    @Option
    public double invar = 0.0;
    @Option
    public int nb_categ = 4;
    @Option
    public double alpha = 1.0;
    @Option
    public String tree = "BIONJ";
    @Option
    public String opt_topology = "y";
    @Option
    public String opt_lengths = "y";

    @Override
    public File createTree(File phylipFile) {
        String cmd = "" + this.phymlPath + " " + phylipFile.getAbsolutePath() + " " + this.data_type + " " + this.format + " " + this.data_sets + " " + this.bootstrap_sets + " " + this.model + " " + this.kappa + " " + this.invar + " " + this.nb_categ + " " + this.alpha + " " + this.tree + " " + this.opt_topology + " " + this.opt_lengths;
        IO.call(cmd, null, this.workingDir);
        String t = IO.f2s(new File(this.workingDir, "converted.phylip_phyml_tree.txt"));
        t = t.replaceAll("\\)1", ")");
        t = t.replaceAll("\\)0", ")");
        File fixed = new File(this.workingDir, "fixed");
        IO.writeToDisk(fixed, t);
        return fixed;
    }

    public static void main(String[] args) {
        IO.run(args, new PhyML(), "generic", PhyloTools.PhyloToolsOptions.class);
    }
}

