/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import fig.basic.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import nuts.io.CSV;
import nuts.io.IO;
import nuts.math.StatisticsMap;
import nuts.util.CollUtils;

public class Subsample
implements Runnable {
    @Option
    public int nLines = 100;
    @Option(required=true)
    public File file = null;
    @Option
    public Random rand = new Random(1L);

    public static void main(String[] args) {
        IO.runLight(args, new Subsample());
    }

    @Override
    public void run() {
        StatisticsMap<Integer> map = new StatisticsMap<Integer>();
        ArrayList lines = CollUtils.list();
        int nCol = 0;
        String header = null;
        int i = 0;
        for (List<String> line : IO.iCSV(this.file)) {
            if (i++ == 0) {
                header = CSV.body(line);
                continue;
            }
            if (line.contains("AVERAGES")) continue;
            lines.add(line);
        }
        IO.so(header);
        Collections.shuffle(lines, this.rand);
        for (i = 0; i < Math.min(lines.size(), this.nLines); ++i) {
            List line = (List)lines.get(i);
            IO.so(CSV.body(line));
            nCol = line.size();
            for (int col = 0; col < line.size(); ++col) {
                double curVal = 0.0;
                try {
                    curVal = Double.parseDouble((String)line.get(col));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                map.addValue(col, curVal);
            }
        }
        ArrayList list = CollUtils.list();
        for (int col = 0; col < nCol; ++col) {
            list.add("" + map.getSummaryStat(col).getMean());
        }
        IO.so(CSV.body(list));
    }
}

