/*
 * Decompiled with CFR 0.152.
 */
package fenchel.measurefacto;

import fenchel.measurefacto.PointwiseOperation;
import fenchel.measurefacto.PointwiseOperationApplicator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nuts.util.MathUtils;

public final class ComputeZeta
implements PointwiseOperation {
    private static ComputeZeta instance = new ComputeZeta();

    public static <M> void computeZeta(PointwiseOperationApplicator<M> applicator, M moment, M xi) {
        List<M> mainArguments = Collections.singletonList(moment);
        ArrayList<M> additionalArguments = new ArrayList<M>();
        additionalArguments.add(xi);
        applicator.apply(instance, mainArguments, additionalArguments);
    }

    private ComputeZeta() {
    }

    @Override
    public void apply(double[][] values, int index) {
        double newZetaValue;
        double moment = values[0][index];
        double xi = values[1][index];
        if (xi == 0.0 || Double.isInfinite(xi)) {
            xi = 1.0;
        }
        values[0][index] = newZetaValue = ComputeZeta.atBoundaries(moment) ? this.convertBoundary(moment) : moment / (1.0 - moment) / xi;
    }

    private double convertBoundary(double moment) {
        if (MathUtils.close(moment, 0.0)) {
            return 0.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    private static boolean atBoundaries(double moment) {
        if (ComputeZeta._atZero(moment)) {
            return true;
        }
        return ComputeZeta._atZero(1.0 - moment);
    }

    private static boolean _atZero(double m) {
        if (m < 0.0) {
            if (!MathUtils.close(m, 0.0)) {
                throw new RuntimeException();
            }
            return true;
        }
        return m == 0.0;
    }
}

