/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class ConvertEncoding {
    @Option(gloss="Input file", condReq="listEncodings=false")
    public static String inFile;
    @Option(gloss="Output file", condReq="listEncodings=false")
    public static String outFile;
    @Option(gloss="Input character encoding", condReq="listEncodings=false")
    public static String inEncoding;
    @Option(gloss="Output character encoding")
    public static String outEncoding;
    @Option(gloss="List possible encodings")
    public static boolean listEncodings;
    @Option(gloss="Convert to lowercase")
    public static boolean lowercase;
    @Option(gloss="Convert to uppercase")
    public static boolean uppercase;

    public static void printCharsets() {
        for (Charset charset : Charset.availableCharsets().values()) {
            LogInfo.logs(charset);
        }
    }

    public static String aliasEncoding(String encoding) {
        if ((encoding = encoding.toUpperCase()).equals("GB")) {
            return "GB2312";
        }
        return encoding;
    }

    public static int copy(Reader in, Writer out) throws IOException {
        int n;
        char[] buf = new char[16384];
        int total = 0;
        while ((n = in.read(buf)) != -1) {
            int i;
            if (uppercase) {
                for (i = 0; i < n; ++i) {
                    buf[i] = Character.toUpperCase(buf[i]);
                }
            }
            if (lowercase) {
                for (i = 0; i < n; ++i) {
                    buf[i] = Character.toLowerCase(buf[i]);
                }
            }
            total += n;
            out.write(buf, 0, n);
        }
        out.flush();
        return total;
    }

    public static void convertFile() throws IOException {
        inEncoding = ConvertEncoding.aliasEncoding(inEncoding);
        outEncoding = ConvertEncoding.aliasEncoding(outEncoding);
        LogInfo.logs("Copying %s (%s) => %s (%s)...", inFile, inEncoding, outFile, outEncoding);
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(inFile), inEncoding);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), outEncoding);
        int n = ConvertEncoding.copy(in, out);
        if (n == -1) {
            throw new RuntimeException("Failed to copy");
        }
        LogInfo.logs("Wrote %d characters", n);
        in.close();
        out.close();
    }

    public static void main(String[] args) {
        Execution.init(args, "main", ConvertEncoding.class);
        try {
            if (listEncodings) {
                ConvertEncoding.printCharsets();
            } else {
                ConvertEncoding.convertFile();
            }
        }
        catch (Throwable t) {
            Execution.raiseException(t);
        }
        Execution.finish();
    }

    static {
        outEncoding = "UTF-8";
        listEncodings = false;
        lowercase = false;
        uppercase = false;
    }
}

