/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.AbstractT2Map;
import fig.basic.AbstractTMap;
import fig.basic.LogInfo;
import fig.basic.T2VMap;
import fig.basic.TDoubleMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class T2DoubleMap<S, T>
extends AbstractT2Map
implements Iterable<Map.Entry<S, TDoubleMap<T>>>,
Serializable {
    protected static final long serialVersionUID = 42L;
    private Map<S, TDoubleMap<T>> maps = new HashMap<S, TDoubleMap<T>>();
    private S lastKey;
    private TDoubleMap<T> lastMap;

    public T2DoubleMap() {
        this.keyFunc = AbstractTMap.defaultFunctionality;
    }

    public T2DoubleMap(AbstractTMap.Functionality<T> keyFunc) {
        this.keyFunc = keyFunc;
    }

    public <V> void initKeys(AbstractT2Map map) {
        this.locked = map.locked;
        if (map instanceof T2DoubleMap) {
            for (Map.Entry<S, TDoubleMap<T>> e : (T2DoubleMap)map) {
                this.put(e.getKey(), new TDoubleMap(e.getValue()));
            }
        } else if (map instanceof T2VMap) {
            for (Map.Entry e : (T2VMap)map) {
                this.put(e.getKey(), new TDoubleMap(e.getValue()));
            }
        } else {
            throw new RuntimeException("");
        }
    }

    public boolean containsKey(S key1, T key2) {
        TDoubleMap<T> map = this.getMap(key1, false);
        return map != null && map.containsKey(key2);
    }

    public double get(S key1, T key2, double defaultValue) {
        TDoubleMap<T> map = this.getMap(key1, false);
        return map == null ? defaultValue : map.get(key2, defaultValue);
    }

    public double getWithErrorMsg(S key1, T key2, double defaultValue) {
        TDoubleMap<T> map = this.getMap(key1, false);
        if (map == null) {
            LogInfo.error("(%s, %s) not in map, using %f", key1, key2, defaultValue);
        }
        return map == null ? defaultValue : map.get(key2, defaultValue);
    }

    public double getSure(S key1, T key2) {
        TDoubleMap<T> map = this.getMap(key1, false);
        if (map == null) {
            throw new RuntimeException("Missing key: " + key1);
        }
        return map.getSure(key2);
    }

    public void put(S key1, TDoubleMap<T> map) {
        if (this.locked) {
            throw new RuntimeException("Cannot make new entry for " + key1 + ", because map is locked");
        }
        this.maps.put(key1, map);
    }

    public void put(S key1, T key2, double value) {
        TDoubleMap<T> map = this.getMap(key1, true);
        map.put(key2, value);
    }

    public void incr(S key1, T key2, double dValue) {
        TDoubleMap<T> map = this.getMap(key1, true);
        map.incr(key2, dValue);
    }

    @Override
    public int size() {
        return this.maps.size();
    }

    public int totalSize() {
        int n = 0;
        for (TDoubleMap<T> map : this.maps.values()) {
            n += map.size();
        }
        return n;
    }

    public void gut() {
        for (TDoubleMap<T> map : this.maps.values()) {
            map.gut();
        }
    }

    @Override
    public Iterator<Map.Entry<S, TDoubleMap<T>>> iterator() {
        return this.maps.entrySet().iterator();
    }

    public Set<Map.Entry<S, TDoubleMap<T>>> entrySet() {
        return this.maps.entrySet();
    }

    public Set<S> keySet() {
        return this.maps.keySet();
    }

    public Collection<TDoubleMap<T>> values() {
        return this.maps.values();
    }

    public T2DoubleMap<S, T> copy() {
        return this.copy(this.newMap());
    }

    public T2DoubleMap<S, T> copy(T2DoubleMap<S, T> newMap) {
        newMap.locked = this.locked;
        for (Map.Entry<S, TDoubleMap<T>> e : this.maps.entrySet()) {
            newMap.maps.put(e.getKey(), e.getValue().copy());
        }
        return newMap;
    }

    public T2DoubleMap<S, T> restrict(Set<S> set1, Set<T> set2) {
        return this.restrict(this.newMap(), set1, set2);
    }

    public T2DoubleMap<S, T> restrict(T2DoubleMap<S, T> newMap, Set<S> set1, Set<T> set2) {
        newMap.locked = this.locked;
        for (Map.Entry<S, TDoubleMap<T>> e : this.maps.entrySet()) {
            if (!set1.contains(e.getKey())) continue;
            newMap.maps.put(e.getKey(), e.getValue().restrict(set2));
        }
        return newMap;
    }

    public T2DoubleMap<T, S> reverse(T2DoubleMap<T, S> newMap) {
        for (Map.Entry<S, TDoubleMap<T>> e1 : this.maps.entrySet()) {
            S key1 = e1.getKey();
            TDoubleMap<T> map = e1.getValue();
            for (TDoubleMap.Entry e2 : map) {
                Object key2 = e2.getKey();
                double value = e2.getValue();
                newMap.put(key2, key1, value);
            }
        }
        return newMap;
    }

    @Override
    public void lock() {
        for (TDoubleMap<T> map : this.maps.values()) {
            map.lock();
        }
    }

    @Override
    public void switchToSortedList() {
        for (TDoubleMap<T> map : this.maps.values()) {
            map.switchToSortedList();
        }
    }

    public void switchToHashTable() {
        for (TDoubleMap<T> map : this.maps.values()) {
            map.switchToHashTable();
        }
    }

    protected T2DoubleMap<S, T> newMap() {
        return new T2DoubleMap<S, T>(this.keyFunc);
    }

    public TDoubleMap<T> getMap(S key1, boolean modify) {
        if (key1 == this.lastKey) {
            return this.lastMap;
        }
        TDoubleMap<T> map = this.maps.get(key1);
        if (map != null) {
            return map;
        }
        if (modify) {
            if (this.locked) {
                throw new RuntimeException("Cannot make new entry for " + key1 + ", because map is locked");
            }
            map = new TDoubleMap(this.keyFunc);
            this.maps.put(key1, map);
            this.lastKey = key1;
            this.lastMap = map;
            return map;
        }
        return null;
    }
}

