/*
 * Decompiled with CFR 0.152.
 */
package fig.exec;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.OrderedStringMap;
import fig.basic.StrUtils;
import fig.basic.SysInfoUtils;
import fig.basic.Utils;
import fig.exec.Execution;
import fig.exec.Job;
import fig.exec.SimpleHTTP;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

public class ExecWorker
implements Runnable {
    @Option
    public String masterURL = "http://localhost:8080/fig/Fig";
    @Option(required=true)
    public String workerName;
    @Option
    public int sleepInterval = 5;
    @Option(gloss="CPU must be free for this many consecutive periods before asking for a job")
    public int conseqCPUFreeBeforeGetJob = 3;
    @Option
    public boolean verbose = false;
    @Option
    public int numSuccessJobs;
    @Option
    public int numJobs;
    @Option(gloss="Create a log file (worker.log) in the execution directory when running a job")
    public boolean logInWorkingDir = false;
    @Option(gloss="RMI port number (for distributed jobs) (-1 for don't enable")
    public int rmiPort = -1;
    public static final String version = "7";
    private Thread runnerThread;
    private Job currJob;
    private boolean terminate;
    private int conseqCPUFree;

    public static void main(String[] args) {
        Execution.run(args, new ExecWorker());
    }

    @Override
    public void run() {
        this.runnerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    if (ExecWorker.this.currJob != null) {
                        this.processJob(ExecWorker.this.currJob);
                        ExecWorker.this.currJob = null;
                        continue;
                    }
                    Utils.sleep(ExecWorker.this.sleepInterval * 1000);
                }
            }

            public void processJob(Job job) {
                if (job == null) {
                    return;
                }
                try {
                    ExecWorker.this.currJob.log("[WORKER] Processing job");
                    String command = job.command;
                    if (job.nice != 0) {
                        command = "nice -n " + job.nice + " " + command;
                    }
                    if (!StrUtils.isEmpty(job.workingDir)) {
                        command = Utils.makeRunCommandInDir(command, job.workingDir);
                    }
                    LogInfo.logs("[WORKER] Running: " + command);
                    boolean success = false;
                    if (ExecWorker.this.logInWorkingDir) {
                        FileOutputStream out = new FileOutputStream(new File(job.workingDir + "/worker.log"));
                        success = Utils.systemLogin(command, out, out);
                    } else {
                        success = Utils.systemLogin(command);
                    }
                    if (success) {
                        ++ExecWorker.this.numSuccessJobs;
                    } else {
                        LogInfo.logs("[WORKER] Job failed");
                    }
                }
                catch (Exception e) {
                    LogInfo.error("[WORKER] processJob() failed: " + e);
                }
                ++ExecWorker.this.numJobs;
                LogInfo.logs("[WORKER] Completed %d/%d jobs successfully", ExecWorker.this.numSuccessJobs, ExecWorker.this.numJobs);
            }
        });
        this.runnerThread.start();
        LogInfo.logss("[WORKER] " + this.workerName + " started");
        while (true) {
            if (this.sendStatus()) {
                if (this.terminate) break;
                if (this.shouldGetJob()) {
                    this.currJob = this.getJob();
                }
            }
            Utils.sleep(this.sleepInterval * 1000);
        }
        this.runnerThread.interrupt();
        LogInfo.logss("[WORKER] " + this.workerName + " terminated");
    }

    private boolean shouldGetJob() {
        if (this.currJob != null) {
            return false;
        }
        int numFreeCPUs = SysInfoUtils.getNumFreeCPUs();
        this.conseqCPUFree = numFreeCPUs > 0 ? ++this.conseqCPUFree : 0;
        return this.conseqCPUFree >= this.conseqCPUFreeBeforeGetJob;
    }

    private String getStatus() {
        if (this.currJob == null) {
            return "idle";
        }
        return "busy";
    }

    private String getProcSummary() {
        String cmd = "ps --no-headers ax -o %cpu,%mem,user,comm 2>/dev/null";
        try {
            ArrayList<String> heavyProcs = new ArrayList<String>();
            for (String line : Utils.systemGetStringOutput(cmd).split("\n")) {
                String[] tokens = line.trim().split(" ");
                if (!(Utils.parseDoubleEasy(tokens[0]) > 50.0)) continue;
                heavyProcs.add(StrUtils.join(tokens, " "));
            }
            return StrUtils.join(heavyProcs, "<br>");
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean sendStatus() {
        String host = SysInfoUtils.getHostName();
        int cpuSpeed = SysInfoUtils.getCPUSpeed();
        int numFreeCPUs = SysInfoUtils.getNumFreeCPUs();
        int numTotalCPUs = SysInfoUtils.getNumCPUs();
        long freeMemory = SysInfoUtils.getFreeMemory();
        if (this.verbose) {
            LogInfo.logs("[WORKER] %s: CPU speed = %d MHz, %d/%d CPUs free", this.workerName, cpuSpeed, numFreeCPUs, numTotalCPUs);
        }
        OrderedStringMap request = this.newRequest("setStatus");
        request.put("host", host);
        request.put("status", this.getStatus());
        request.put("version", version);
        request.put("uptime", LogInfo.getWatch().stop());
        request.put("cpuSpeed", "" + cpuSpeed);
        request.put("numFreeCPUs", "" + numFreeCPUs);
        request.put("numTotalCPUs", "" + numTotalCPUs);
        request.put("freeMemory", "" + freeMemory);
        request.put("procSummary", this.getProcSummary());
        request.put("numSuccessJobs", "" + this.numSuccessJobs);
        request.put("numJobs", "" + this.numJobs);
        OrderedStringMap response = this.makeHTTPRequest(request);
        if (response == null) {
            return false;
        }
        if ("true".equals(response.get("kill"))) {
            this.runnerThread.interrupt();
        }
        if ("true".equals(response.get("terminate"))) {
            this.terminate = true;
        }
        return true;
    }

    public Job getJob() {
        OrderedStringMap request = this.newRequest("getJob");
        OrderedStringMap response = this.makeHTTPRequest(request);
        return Job.parse(response);
    }

    private OrderedStringMap newRequest(String op) {
        OrderedStringMap request = new OrderedStringMap();
        request.put("mode", "op");
        request.put("trail", "workers\tworkers\t" + this.workerName);
        request.put("op", op);
        return request;
    }

    public OrderedStringMap makeHTTPRequest(OrderedStringMap request) {
        try {
            if (this.verbose) {
                request.log("[WORKER] Request");
            }
            String url = SimpleHTTP.createURL(this.masterURL, request);
            List<String> lines = SimpleHTTP.getLines(url);
            OrderedStringMap response = new OrderedStringMap();
            for (String line : lines) {
                String[] tokens = line.split("\t", 2);
                if (tokens.length != 2) continue;
                response.put(tokens[0], tokens[1]);
            }
            if (!"true".equals(response.get("success"))) {
                LogInfo.logs("[WORKER] Request failed: " + url);
                response.log("[WORKER] Response");
                return null;
            }
            if (this.verbose) {
                response.log("[WORKER] Response");
            }
            return response;
        }
        catch (Exception e) {
            LogInfo.logs("[WORKER] Unable to contact %s right now: %s", this.masterURL, e);
            return null;
        }
    }
}

