/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.IOUtils;
import fig.basic.Pair;
import fig.exec.servlet.ConstantField;
import fig.exec.servlet.DirSource;
import fig.exec.servlet.ExecFactory;
import fig.exec.servlet.ExecItem;
import fig.exec.servlet.ExecView;
import fig.exec.servlet.ExecViewDB;
import fig.exec.servlet.Field;
import fig.exec.servlet.FilenameFilterBank;
import fig.exec.servlet.GroundedExecView;
import fig.exec.servlet.MyException;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import fig.exec.servlet.WebState;
import java.io.File;

public class AllExecView
extends ExecView {
    public AllExecView(Trail trail, DirSource source, ExecFactory factory) {
        super(trail, source, factory);
    }

    @Override
    protected Field getField(String key, String gloss) {
        if (key.equals("description")) {
            return new ConstantField(key, gloss, "All executions");
        }
        if (key.equals("note")) {
            return new ConstantField(key, gloss, "");
        }
        return super.getField(key, gloss);
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        DirSource.TraverseSpec tspec = new DirSource.TraverseSpec(new FilenameFilterBank.Compose(new FilenameFilterBank.Regex(".*\\.exec", true), FilenameFilterBank.onlyDir()), new FilenameFilterBank.Compose(new FilenameFilterBank.Regex(".*\\.exec.*", false), FilenameFilterBank.onlyDir()));
        this.updateItemsFromDir((DirSource)this.source, -1, tspec, this.factory, false);
        ExecViewDB execViewDB = this.source.getDomainView().getExecViewDB();
        for (ExecItem item : this.getItems().values()) {
            GroundedExecView view;
            File path = new File(item.getGroundedPath(), "addToView");
            String viewName = IOUtils.readLineEasy(path.toString());
            if (!execViewDB.getItems().containsKey(viewName) || !(view = (GroundedExecView)execViewDB.getItem(viewName)).hasUpdated()) continue;
            WebState.logs("Adding %s to view %s", item, viewName);
            view.addSave(item);
            path.delete();
        }
        this.updateChildren(spec, priority);
    }

    @Override
    protected Pair<String, Boolean> getDefaultSortSpec() {
        return new Pair<String, Boolean>("date", true);
    }
}

