/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.exec.servlet.MyException;

public class Exceptions {
    public static RuntimeException unknownCase() {
        return new RuntimeException("Unknown case (shouldn't happen)");
    }

    public static MyException unsupported(String op, Object x) {
        return new MyException("Operation " + op + " not supported for " + x);
    }

    public static MyException TODO() {
        return new MyException("I will fix this later");
    }

    public static MyException filePermissionDenied(String msg) {
        return new MyException("Permission denied: " + msg);
    }

    public static MyException cantExecute(Object o) {
        return new MyException("Can't execute: " + o);
    }

    public static <T> T cast(Object o, Class<T> c) throws MyException {
        try {
            return c.cast(o);
        }
        catch (ClassCastException e) {
            throw new MyException("Invalid type: wanted type " + c + ", but got " + o + " with type " + (o == null ? null : o.getClass()));
        }
    }

    public static <T> T castEasy(Object o, Class<T> c) {
        try {
            return c.cast(o);
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

