/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.OrderedMap;
import fig.basic.Pair;
import fig.exec.servlet.AllExecView;
import fig.exec.servlet.ConstantField;
import fig.exec.servlet.DirSource;
import fig.exec.servlet.ExecFactory;
import fig.exec.servlet.ExecItem;
import fig.exec.servlet.ExecView;
import fig.exec.servlet.ExecViewDB;
import fig.exec.servlet.Field;
import fig.exec.servlet.GroundedExecView;
import fig.exec.servlet.MyException;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import java.util.HashSet;

public class OrphanedExecView
extends ExecView {
    public OrphanedExecView(Trail trail, DirSource source, ExecFactory factory) {
        super(trail, source, factory);
    }

    @Override
    protected Field getField(String key, String gloss) {
        if (key.equals("description")) {
            return new ConstantField(key, gloss, "Orphaned executions");
        }
        if (key.equals("note")) {
            return new ConstantField(key, gloss, "");
        }
        return super.getField(key, gloss);
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        ExecViewDB execViewDB = this.source.getDomainView().getExecViewDB();
        AllExecView allExecView = execViewDB.getAllExecView();
        HashSet<ExecItem> hitItems = new HashSet<ExecItem>();
        for (ExecView execView : execViewDB.getItems().values()) {
            if (!(execView instanceof GroundedExecView)) continue;
            for (ExecItem item : execView.getItems().values()) {
                hitItems.add(item);
            }
        }
        OrderedMap newItems = new OrderedMap();
        for (ExecItem item : allExecView.getItems().values()) {
            if (hitItems.contains(item)) continue;
            this.addItem(newItems, item);
        }
        this.items = newItems;
        this.updateChildren(spec, priority);
        spec.getQueue().enqueue(allExecView, priority.next());
    }

    @Override
    protected Pair<String, Boolean> getDefaultSortSpec() {
        return new Pair<String, Boolean>("date", true);
    }
}

