/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.Pair;
import fig.exec.servlet.Exceptions;
import fig.exec.servlet.Item;
import fig.exec.servlet.WebState;
import java.util.IdentityHashMap;
import java.util.LinkedList;

public class UpdateQueue {
    private LinkedList<Item>[] queues = new LinkedList[3];
    private IdentityHashMap<Item, Priority> priorities;

    public UpdateQueue() {
        for (int i = 0; i < 3; ++i) {
            this.queues[i] = new LinkedList();
        }
        this.priorities = new IdentityHashMap();
    }

    public synchronized int queueSize() {
        int sum = 0;
        for (int i = 0; i < 3; ++i) {
            sum += this.queues[i].size();
        }
        return sum;
    }

    private int priorityToIndex(Priority priority) {
        if (priority == Priority.HIGH) {
            return 0;
        }
        if (priority == Priority.MED) {
            return 1;
        }
        if (priority == Priority.LOW) {
            return 2;
        }
        throw Exceptions.unknownCase();
    }

    private Priority indexToPriority(int i) {
        if (i == 0) {
            return Priority.HIGH;
        }
        if (i == 1) {
            return Priority.MED;
        }
        if (i == 2) {
            return Priority.LOW;
        }
        throw Exceptions.unknownCase();
    }

    private synchronized void removeItem(Item item) {
        Priority priority = this.priorities.remove(item);
        if (priority != null) {
            this.queues[this.priorityToIndex(priority)].remove(item);
        }
    }

    public synchronized void enqueue(Item item, Priority priority) {
        if (this.enqueueHelper(item, priority)) {
            WebState.verboseLogs("UpdateSpec.enqueue(): " + item + ", priority = " + priority);
        }
    }

    private synchronized boolean enqueueHelper(Item item, Priority priority) {
        Priority oldPriority = this.priorities.get(item);
        if (oldPriority == priority) {
            return false;
        }
        this.removeItem(item);
        this.queues[this.priorityToIndex(priority)].addLast(item);
        this.priorities.put(item, priority);
        return true;
    }

    public synchronized void merge(UpdateQueue queue) {
        for (int i = 0; i < 3; ++i) {
            for (Item item : queue.queues[i]) {
                this.enqueueHelper(item, this.indexToPriority(i));
            }
        }
    }

    public synchronized Pair<Item, Priority> dequeue() {
        for (int i = 0; i < 3; ++i) {
            if (this.queues[i].size() == 0) continue;
            Item item = this.queues[i].removeFirst();
            Priority priority = this.priorities.remove(item);
            WebState.verboseLogs("UpdateSpec.dequeue(): return " + item + ", priority = " + this.indexToPriority(i));
            return new Pair<Item, Priority>(item, priority);
        }
        return null;
    }

    public String toString() {
        return String.format("UpdateQueue(%d/%d/%d items)", this.queues[0].size(), this.queues[1].size(), this.queues[2].size());
    }

    public static class Priority {
        private int value;
        public static Priority HIGH = new Priority(0);
        public static Priority MED = new Priority(1);
        public static Priority LOW = new Priority(2);

        private Priority(int value) {
            this.value = value;
        }

        public Priority next() {
            if (this == HIGH) {
                return MED;
            }
            if (this == MED) {
                return LOW;
            }
            return LOW;
        }

        public String toString() {
            return "" + this.value;
        }
    }
}

