/*
 * Decompiled with CFR 0.152.
 */
package fig.html;

import fig.html.HtmlCell;
import fig.html.HtmlElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HtmlRow
extends HtmlElement {
    private boolean isHeader;
    private List<HtmlCell> cells = new ArrayList<HtmlCell>();

    public HtmlRow() {
    }

    public HtmlRow(boolean isHeader, List<? extends Object> values) {
        this.setIsHeader(isHeader);
        this.addCells(values);
    }

    public void setIsHeader(boolean isHeader) {
        this.isHeader = isHeader;
    }

    public HtmlCell addCell(HtmlCell cell) {
        this.cells.add(cell);
        return cell;
    }

    public HtmlCell addCell(String value) {
        HtmlCell cell = new HtmlCell(value);
        this.cells.add(cell);
        return cell;
    }

    public void addCells(List<? extends Object> values) {
        for (Object object : values) {
            this.addCell(new HtmlCell(object));
        }
    }

    @Override
    protected void renderInnerHTML(StringBuilder sb, Map<String, Map<String, String>> inheritedAttributesSet) {
        for (HtmlCell cell : this.cells) {
            if (this.isHeader) {
                cell.bold = true;
            }
            cell.render(sb, inheritedAttributesSet);
        }
    }

    @Override
    public String getTag() {
        return "tr";
    }

    public HtmlCell getCell(int i) {
        return this.cells.get(i);
    }
}

