/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.Exceptions;
import fig.record.CommandNode;
import fig.record.FullRecordNode;
import fig.record.LeafRecordNode;
import fig.record.LocalCommandEnv;
import fig.record.RecordNode;
import java.util.Iterator;

public class CombineCommandNode
extends FullRecordNode
implements CommandNode {
    public CombineType combineType;

    public CombineCommandNode(CombineType combineType) {
        super(combineType.toString(), null);
        this.combineType = combineType;
    }

    @Override
    public RecordNode exec(LocalCommandEnv localEnv) {
        if (this.combineType == CombineType.CONCAT) {
            FullRecordNode result = new FullRecordNode("concat", null);
            for (RecordNode childCmd : this.getChildren()) {
                result.addChild(((CommandNode)childCmd).exec(localEnv.withHintIsDefault()));
            }
            return localEnv.applyHint(result);
        }
        if (this.combineType == CombineType.AND) {
            RecordNode childCmd;
            RecordNode result = LeafRecordNode.nullNode;
            Iterator<RecordNode> iterator = this.getChildren().iterator();
            while (iterator.hasNext() && !CombineCommandNode.isFailure(result = ((CommandNode)(childCmd = iterator.next())).exec(localEnv.withHintIsSame()))) {
            }
            return result;
        }
        if (this.combineType == CombineType.COMPOSE) {
            RecordNode result = LeafRecordNode.nullNode;
            for (RecordNode childCmd : this.getChildren()) {
                result = ((CommandNode)childCmd).exec(localEnv.withHintIsDefault());
                localEnv = localEnv.withCurrRecord(result);
            }
            return localEnv.applyHint(result);
        }
        throw new RuntimeException("Unknown combine type: " + (Object)((Object)this.combineType));
    }

    public static CombineType parseCombineType(String s) {
        if (s == null) {
            return CombineType.COMPOSE;
        }
        if (s.equals("+")) {
            return CombineType.CONCAT;
        }
        if (s.equals("&")) {
            return CombineType.AND;
        }
        if (s.equals("@")) {
            return CombineType.COMPOSE;
        }
        throw Exceptions.unknownCase;
    }

    public static boolean isFailure(RecordNode record) {
        return record.numChildren() == 0;
    }

    @Override
    public RecordNode withoutChildren() {
        return new CombineCommandNode(this.combineType);
    }

    public static enum CombineType {
        CONCAT,
        AND,
        COMPOSE;

    }
}

