/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.ListUtils;
import fig.record.CommandNode;
import fig.record.FullRecordNode;
import fig.record.LocalCommandEnv;
import fig.record.Matcher;
import fig.record.OrMatcher;
import fig.record.RecordNode;
import fig.record.RecordNodeMatcher;
import fig.record.SubsetHint;
import fig.record.SubsetHintUtils;
import fig.record.SubsetOracle;
import fig.record.TwigRecordNode;
import fig.record.VarBindingList;
import java.util.List;

public class FilterCommandNode
extends TwigRecordNode
implements CommandNode {
    private RecordNodeMatcher matcher;

    public FilterCommandNode(RecordNodeMatcher matcher, CommandNode child) {
        super("filter", matcher.toString(), child);
        this.matcher = matcher;
    }

    @Override
    public RecordNode exec(LocalCommandEnv localEnv) {
        RecordNode record = localEnv.getCurrRecord();
        CommandNode childCmd = (CommandNode)this.getChild();
        if (this.matcher.matchesAll()) {
            return SubsetHintUtils.applyHint(localEnv.getHint(), record, childCmd, localEnv);
        }
        FullRecordNode result = new FullRecordNode(record.getKey(), record.getValue());
        List<RecordNode> childRecords = record.getChildren();
        SubsetHint hint = localEnv.getHint();
        VarBindingList bindings = localEnv.getVarBindingList();
        SubsetOracle oracle = null;
        if (this.matcher.getKeyMatcher() instanceof OrMatcher || this.matcher.getValueMatcher() instanceof OrMatcher) {
            Matcher keyMatcher = this.matcher.getKeyMatcher();
            Matcher valueMatcher = this.matcher.getValueMatcher();
            List<Matcher> keyMatchers = keyMatcher instanceof OrMatcher ? ((OrMatcher)keyMatcher).getMatchers() : ListUtils.newList(keyMatcher);
            List<Matcher> valueMatchers = valueMatcher instanceof OrMatcher ? ((OrMatcher)valueMatcher).getMatchers() : ListUtils.newList(valueMatcher);
            for (int q = 0; q < 2; ++q) {
                if (q == 0 && !hint.needTotalCount()) {
                    oracle = hint.getOracle(0);
                    continue;
                }
                int n = 0;
                for (Matcher k : keyMatchers) {
                    for (Matcher v : valueMatchers) {
                        for (RecordNode childRecord : childRecords) {
                            if (!k.matches(childRecord.getKey(), bindings) || !v.matches(childRecord.getValue(), bindings)) continue;
                            if (q == 1 && oracle.inSubset(n)) {
                                result.addChild(childCmd.exec(localEnv.withCurrRecord(childRecord).withHintIsDefault().withIndex(n)));
                            }
                            ++n;
                        }
                    }
                }
                if (q != 0) continue;
                oracle = hint.getOracle(n);
            }
        } else {
            for (int q = 0; q < 2; ++q) {
                if (q == 0 && !hint.needTotalCount()) {
                    oracle = hint.getOracle(0);
                    continue;
                }
                int n = 0;
                for (RecordNode childRecord : childRecords) {
                    if (!this.matcher.matches(childRecord, bindings)) continue;
                    if (q == 1 && oracle.inSubset(n)) {
                        result.addChild(childCmd.exec(localEnv.withCurrRecord(childRecord).withHintIsDefault().withIndex(n)));
                    }
                    ++n;
                }
                if (q != 0) continue;
                oracle = hint.getOracle(n);
            }
        }
        return result;
    }

    @Override
    public RecordNode withoutChildren() {
        return new FilterCommandNode(this.matcher, null);
    }
}

