/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.servlet.FieldListMap;
import fig.servlet.FileFactory;
import fig.servlet.FileItem;
import fig.servlet.FileUtils;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import java.io.File;

public class FileView
extends FileItem {
    private FileFactory factory;
    private boolean recursive;
    private boolean listAll;

    public FileView(Item parent, String name, String sourcePath, FileFactory factory, boolean recursive, boolean listAll) {
        super(parent, name, sourcePath);
        this.factory = factory;
        this.recursive = recursive;
        this.listAll = listAll;
    }

    @Override
    protected boolean isView() {
        return true;
    }

    @Override
    protected Item newItem(String name) throws MyException {
        File file = new File(this.sourcePath, name);
        if (!file.exists()) {
            throw new MyException("Doesn't exist: " + file);
        }
        return this.factory.newFileItem(this, name, file.toString());
    }

    @Override
    public FieldListMap getItemsFields() {
        return new FileItem(null, null, null).getMetadataFields();
    }

    @Override
    protected String fileSourcePath() {
        return null;
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        super.update(spec, priority);
        if (this.listAll) {
            this.updateItemsFromDir(this.recursive ? -1 : 1, FileUtils.TraverseSpec.allowAll(), false);
        }
        for (Item item : this.items.values()) {
            ((FileItem)item).updateShallow(spec);
        }
    }

    @Override
    protected String tableType() {
        return "FileView";
    }

    @Override
    protected String getDescription() {
        return "Browse the file system.";
    }
}

