/*
 * Decompiled with CFR 0.152.
 */
package gep.pmcmc;

import gep.model.SufficientStatistics;
import gep.timeseries.Event;
import java.util.Collections;
import java.util.List;

public class PartialHiddenState<S> {
    private final SufficientStatistics<S, S> currentStats;
    private final List<Event<S>> events;
    private final int nObservationAskedToCover;

    public PartialHiddenState(SufficientStatistics<S, S> currentStats, List<Event<S>> events, int nObservationAskedToCover) {
        this.currentStats = currentStats;
        this.events = events;
        this.nObservationAskedToCover = nObservationAskedToCover;
    }

    public List<Event<S>> eventsList() {
        return Collections.unmodifiableList(this.events);
    }

    public int nObservationAskedToCover() {
        return this.nObservationAskedToCover;
    }

    public double eventsLength() {
        if (this.events.isEmpty()) {
            return 0.0;
        }
        return this.events.get(this.events.size() - 1).right();
    }

    public SufficientStatistics<S, S> suffStats() {
        return this.currentStats;
    }
}

