/*
 * Decompiled with CFR 0.152.
 */
package gep.util;

import java.util.Random;

public class TP {
    public static double sample(Random rand, double alpha, double beta) {
        if (!(alpha > 0.0) || !(beta > 0.0)) {
            throw new RuntimeException();
        }
        double u = rand.nextDouble();
        double u1a = Math.pow(u, 1.0 / alpha);
        double result = beta * (1.0 - u1a) / u1a;
        if (!(result > 0.0)) {
            throw new RuntimeException("TP.sample(alpha=" + alpha + ",beta=" + beta + ") returned " + result + "; u=" + u + ",u1a=" + u1a);
        }
        return result;
    }

    public static double mean(double alpha, double beta) {
        if (alpha <= 0.0 || beta <= 0.0) {
            throw new RuntimeException();
        }
        if (alpha <= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return beta * (alpha / (alpha - 1.0) - 1.0);
    }

    public static void main(String[] args) {
        int i;
        double cur = Double.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < 10000000; ++i2) {
            double term = (Math.log(i2) - Math.log(i2 + 1)) * (double)i2;
            if (term > cur) {
                throw new RuntimeException("" + i2);
            }
            cur = term;
        }
        double as = 0.0;
        for (int i3 = 0; i3 < 100000000; ++i3) {
            as += Math.pow((double)i3 / ((double)i3 + 1.0), i3);
            if (i3 % 1000000 != 0) continue;
            System.out.println(as);
        }
        double alpha = 0.1;
        double beta = 0.1;
        double sum = 0.0;
        double N2 = 1000000.0;
        Random rand = new Random(2L);
        double curAlpha = 0.1;
        double curBeta = 0.1;
        for (i = 0; i < 10000; ++i) {
            double t = TP.sample(rand, curAlpha, curBeta);
            curAlpha += 1.0;
            curBeta += t;
            System.out.println("" + i + "\t" + t);
        }
        System.out.println("---");
        i = 0;
        while ((double)i < N2) {
            double cSample = TP.sample(rand, 0.1, 0.1);
            System.out.println(cSample);
            sum += cSample;
            ++i;
        }
        System.out.println("Analytic:" + TP.mean(0.1, 0.1));
        System.out.println("MC:" + sum / N2);
    }
}

