/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import goblin.BayesRiskMinimizer;
import java.util.ArrayList;
import nuts.io.IO;

public class BuildPMJBaseline {
    public static void main(String[] args) {
        if (args.length < 3) {
            IO.so("goblin.BuildPMJBaseline <path-to-cognate-set> <gold-field> (<guess-fields>)+");
            return;
        }
        int goldField = Integer.parseInt(args[1]);
        BayesRiskMinimizer.LevenshteinLoss loss = BayesRiskMinimizer.levenshteinLoss;
        int lineNumber = -1;
        IO.so("----");
        ArrayList<Integer> guessFields = new ArrayList<Integer>();
        for (int i = 2; i < args.length; ++i) {
            guessFields.add(Integer.parseInt(args[i]));
        }
        for (String line : IO.i(args[0])) {
            if (lineNumber == -1) {
                lineNumber = 0;
                continue;
            }
            if (line.equals("")) continue;
            String[] fields = line.split(" ");
            String gold = fields[goldField];
            String guess = "?";
            for (int i = 0; i < guessFields.size() && guess.equals("?"); ++i) {
                guess = fields[(Integer)guessFields.get(i)];
            }
            if (gold.equals("?") || guess.equals("?")) {
                ++lineNumber;
                continue;
            }
            IO.so("ID " + fields[0]);
            IO.so("TRUTH " + gold);
            IO.so("PRAGUE " + guess);
            IO.so("LOSS " + loss.loss(gold, guess));
            IO.so("----");
            ++lineNumber;
        }
    }
}

