/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.Option;
import goblin.HLEM;
import goblin.HLFeatureExtractor;
import goblin.HLParams;
import goblin.HLParamsUpdater;
import goblin.Taxon;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import nuts.util.Counter;
import pepper.Encodings;

public class HLParamsLoader {
    @Option
    public double noiseRate = 0.0;
    @Option(gloss="If true, use Gaussian generation, o.w., multinomials (see HLParamsLoader.java)")
    public boolean generationInFeatureSpace = true;
    @Option(gloss="Path to a serialized HLParams/weights")
    public String paramsPath;
    @Option(gloss="Seed used to generate random parameters")
    public Random paramGenerationRand = new Random(1L);
    @Option(gloss="In the context where generationInFeatureSpace=false, see HLParamsLoader.java")
    public boolean denyIndel = false;
    @Option
    public boolean checkFeatInit = true;
    @Option
    public String encPath = "";
    @Option(gloss="Standard deviation of the random gaussian weights")
    public double stdDev = 1.0;
    private HLParams params;
    private boolean loaded = false;
    private Set<Taxon> languages;
    private HLFeatureExtractor featureExtractor;

    public void setFeatureExtractor(HLFeatureExtractor featureEx) {
        this.featureExtractor = featureEx;
    }

    public void setLanguages(Set<Taxon> languages) {
        if (this.loaded) {
            throw new RuntimeException("Cannot setLanguages after loaded in HLParamsLoader");
        }
        this.languages = new HashSet<Taxon>(languages);
    }

    public HLParams getParams() {
        if (!this.loaded) {
            this.load();
        }
        return this.params;
    }

    private void load() {
        HLParams randParam;
        HLParams deterParam = this.noiseRate < 1.0 ? this.deterministicParams() : null;
        HLParams hLParams = randParam = this.noiseRate > 0.0 ? this.generateParams() : null;
        if (this.noiseRate != 1.0 && this.noiseRate != 0.0 && !randParam.enc.equals(deterParam.enc)) {
            throw new RuntimeException("Problem with HLParamsLoader.load()");
        }
        this.params = HLParams.mixture(randParam, deterParam, this.noiseRate);
        Encodings.registerEncodings(this.params.enc);
        this.loaded = true;
    }

    private HLParams generateParams() {
        Encodings enc = Encodings.getGlobalEncodings();
        if (enc == null) {
            enc = Encodings.toyCtxFreeEncodings();
        }
        if (this.generationInFeatureSpace) {
            return HLParams.randomHLParams(this.paramGenerationRand, enc, this.languages, this.featureExtractor, this.stdDev);
        }
        return HLParams.randomHLParams(this.paramGenerationRand, enc, this.languages, this.denyIndel);
    }

    private HLParams deterministicParams() {
        if (this.loadFromSeri()) {
            try {
                HLParams result = HLParams.restoreHLParams(this.paramsPath);
                Encodings.registerEncodings(result.enc);
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Encodings enc = Encodings.getGlobalEncodings();
        if (enc == null) {
            enc = this.encPath.equals("") ? Encodings.toyCtxFreeEncodings() : Encodings.restoreEncodings(this.encPath);
            Encodings.registerEncodings(enc);
        }
        Counter ws = HLParamsUpdater.restoreCounter(this.paramsPath);
        return HLParams.createHLParamsFromWeights(enc, this.languages, this.featureExtractor, ws, this.checkFeatInit, HLEM.hliOptions.numThreads);
    }

    public boolean loadFromSeri() {
        if (this.paramsPath.length() < 8) {
            return false;
        }
        return this.paramsPath.substring(this.paramsPath.length() - 8).equals("HLParams");
    }
}

