/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.IOUtils;
import goblin.ParamsTracker;
import goblin.Taxon;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import nuts.io.IO;
import pepper.Encodings;
import pepper.editmodel.EditParam;
import pepper.editmodel.PhonemeModel;

public class ParamsTrackers {
    public static void saveParamsTracker(ParamsTracker params, String filePath) throws IOException {
        ObjectOutputStream oos = IOUtils.openBinOut(filePath);
        oos.writeObject(params);
        oos.close();
    }

    public static ParamsTracker restoreParamsTracker(String filePath) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = IOUtils.openBinIn(filePath);
        return (ParamsTracker)ois.readObject();
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        ParamsTracker pm = ParamsTrackers.restoreParamsTracker(args[0]);
        IO.so(pm.getEditParam(new Taxon(args[1])).toString());
    }

    public static class HomoParamsTracker
    implements ParamsTracker {
        private static final long serialVersionUID = 2L;
        private final EditParam editParam;
        private final PhonemeModel pm;

        public HomoParamsTracker(EditParam editParam, PhonemeModel pm) {
            this.editParam = editParam;
            this.pm = pm;
        }

        public HomoParamsTracker(EditParam editParam) {
            this(editParam, new PhonemeModel(editParam.getEncodings()));
        }

        @Override
        public EditParam getEditParam(Taxon lang) {
            return this.editParam;
        }

        @Override
        public Encodings getEncodings() {
            return this.editParam.getEncodings();
        }

        @Override
        public PhonemeModel getRootPhonemeModel() {
            return this.pm;
        }
    }

    public static class ParamsTrackerMap
    implements ParamsTracker {
        private static final long serialVersionUID = 1540199549463382415L;
        private Map<Taxon, EditParam> params = new HashMap<Taxon, EditParam>();
        private PhonemeModel rootPhonemeModel;
        private Encodings enc;

        public ParamsTrackerMap(Map<Taxon, EditParam> params, PhonemeModel rootPhonemeModel) {
            assert (params.size() > 0);
            this.params.putAll(params);
            this.enc = params.values().iterator().next().getEncodings();
            this.rootPhonemeModel = rootPhonemeModel;
        }

        @Override
        public PhonemeModel getRootPhonemeModel() {
            return this.rootPhonemeModel;
        }

        @Override
        public EditParam getEditParam(Taxon lang) {
            if (!this.params.containsKey(lang)) {
                throw new RuntimeException();
            }
            return this.params.get(lang);
        }

        @Override
        public Encodings getEncodings() {
            return this.enc;
        }
    }
}

