/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import fig.basic.LogInfo;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import nuts.util.CollUtils;
import smc.SMC;

public class Visualizer {
    public static final String FILE_LOCATION = "data/distributed/";
    public static final String FILE_NAME = "smcTree";
    public static final String FILE_TYPE = "png";
    public static final int IMAGE_WIDTH = 100;
    public static final int IMAGE_HEIGHT = 100;
    public static final int WIDTH_MARGIN = 20;
    public static final int HEIGHT_MARGIN = 10;

    public static <S> void createImage(int N2, int T, List<SMC.Particle<S>> rootParticles) {
        BufferedImage image = new BufferedImage(120, 110, 1);
        Graphics2D g2 = image.createGraphics();
        ArrayList queue = CollUtils.list();
        double t_init = 0.0;
        for (SMC.Particle<S> root : rootParticles) {
            queue.add(0, root);
            t_init = root.time;
        }
        double width = 100.0 / (double)N2;
        double height = 100.0 / ((double)T - t_init);
        double n_curr = 0.0;
        double t_curr = 0.0;
        int n = 0;
        int t = 0;
        while (!queue.isEmpty()) {
            SMC.Particle p = (SMC.Particle)queue.remove(0);
            if ((double)p.time - t_init > (double)t) {
                LogInfo.logs("at t=" + ((double)t + t_init + 1.0) + ", # of particles=" + n);
                t_curr += height * 1.05;
                ++t;
                n_curr = 0.0;
                n = 0;
            }
            g2.draw(new Ellipse2D.Double(n_curr, t_curr, width, height));
            queue.addAll(p.children);
            n_curr += width * 1.1;
            ++n;
        }
        LogInfo.logs("at t=" + ((double)t + t_init + 1.0) + ", # particles=" + n);
    }
}

