/*
 * Decompiled with CFR 0.152.
 */
package ma;

import java.io.File;
import java.io.IOException;
import java.util.List;
import ma.BalibaseCorpus;
import ma.MultiAlignment;
import nuts.io.IO;
import nuts.lang.StringUtils;

public class Baliscore {
    private static String baliScorePath = "/work/bouchard/bin/bali_score";

    public static void main(String[] args) throws IOException {
        if (args.length != 1 && args.length != 2) {
            System.out.println("Arguments: [path to refs] (extension of the guesses in the curr dir)");
            return;
        }
        double denom = 0.0;
        double ourNumCS = 0.0;
        double ourNumSP = 0.0;
        String extension = args.length == 1 ? "msf" : args[1];
        File baliPath = new File(args[0]);
        for (String file : IO.ls(".", extension)) {
            String stemmedFile = extension == null ? file : file.replaceAll("[.]" + extension + "$", "");
            String refPath = new File(baliPath, stemmedFile + ".msf").getPath();
            String processedFile = file;
            if (extension != null && extension.equals("aln")) {
                MultiAlignment guess = MultiAlignment.parseALNToMultiAlignment(file, "");
                String msfConverted = guess.createAlignmentMatrix().toMSFString();
                IO.writeToDisk("temp", msfConverted);
                processedFile = "temp";
            }
            String callStr = baliScorePath + " " + refPath + " " + processedFile;
            try {
                BalibaseCorpus.getBalibaseAnnFile(new File(stemmedFile + ".msf"), new File(baliPath.getPath()));
            }
            catch (Exception e) {
                System.err.println("File " + stemmedFile + " ignored (no ann file)");
                continue;
            }
            double ourCS = Baliscore.ourScore(stemmedFile + ".msf", baliPath.getPath(), processedFile, false);
            double ourSP = Baliscore.ourScore(stemmedFile + ".msf", baliPath.getPath(), processedFile, true);
            System.out.println("Our CS for " + file + ":" + ourCS);
            denom += 1.0;
            ourNumCS += ourCS;
            ourNumSP += ourSP;
        }
        System.out.println("------------------------------------------------------");
        System.out.println("       Average CS: " + ourNumCS / denom);
        System.out.println("       Average SP: " + ourNumSP / denom);
    }

    public static double ourScore(String msfFile, String baliPath, String guessFile, boolean usePairs) throws IOException {
        MultiAlignment guess = MultiAlignment.parseMSFToMultiAlignment(guessFile);
        File annPath = BalibaseCorpus.getBalibaseAnnFile(new File(msfFile), new File(baliPath));
        File refPath = new File(baliPath, msfFile);
        MultiAlignment ref = MultiAlignment.parseMSFToMultiAlignment(refPath.getPath(), annPath.getPath());
        return usePairs ? ref.sumOfPairsScore(guess) : ref.columnScore(guess);
    }

    private static double parseBaliScoreCS(String string) {
        List<String> selectMatch = StringUtils.selectRegex("TC score[=] ([0-9][.][0-9]*)", string);
        if (selectMatch.size() != 1) {
            return Double.NaN;
        }
        String TCString = selectMatch.get(0);
        return Double.parseDouble(TCString);
    }
}

