/*
 * Decompiled with CFR 0.152.
 */
package ma;

import fig.basic.IOUtils;
import fig.basic.Option;
import goblin.CognateId;
import goblin.Taxon;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import ma.BioCorpus;
import ma.LoadBench;
import ma.MSAPoset;
import ma.MultiAlignment;
import ma.SequenceType;
import ma.newick.NewickParser;
import nuts.io.IO;
import nuts.util.CollUtils;
import nuts.util.Tree;

public class BenchCorpus
extends BioCorpus {
    private static final long serialVersionUID = 1L;
    private final BenchCorpusOptions options;
    public static BenchCorpusOptions _benchOptions = new BenchCorpusOptions();
    private Map<CognateId, MSAPoset> msaPosets = CollUtils.map();

    public BenchCorpus(BenchCorpusOptions options) {
        super(SequenceType.PROTEIN);
        this.options = options;
        this.init();
    }

    private void init() {
        this.loadAligns();
        this.loadTopos();
    }

    private void loadTopos() {
        for (File f : IO.ls(new File(this.options.treeFolder), this.options.treeExtension)) {
            try {
                NewickParser parser = new NewickParser(IOUtils.openIn(f));
                Tree<String> currentTopo = parser.parse();
                Map<Taxon, Double> bl = parser.getBranchLengths();
                for (Taxon lang : bl.keySet()) {
                    if (!(bl.get(lang) < this.options.minBranchLength)) continue;
                    System.err.println("Setting to min branch length:" + bl.get(lang) + " -> " + this.options.minBranchLength);
                    bl.put(lang, this.options.minBranchLength);
                }
                CognateId id = new CognateId(f.getName().replaceAll("[.]" + this.options.treeExtension, ""));
                this.topologies.put(id, currentTopo);
                this.branchLengths.put(id, bl);
            }
            catch (Exception e) {
                System.err.println("Bad topo file:" + f + "... skipping.");
                e.printStackTrace();
            }
        }
    }

    @Override
    public MSAPoset getMSAPoset(CognateId id) {
        return this.msaPosets.get(id);
    }

    @Override
    public MultiAlignment getMultiAlignment(CognateId id) {
        return this.getMSAPoset(id).toMultiAlignmentObject();
    }

    public static void main(String[] args) throws Exception {
        ObjectInputStream in = IOUtils.openObjIn(args[0]);
        BenchCorpus bc = (BenchCorpus)in.readObject();
        System.out.println(bc.intersectedIds().size());
    }

    private void loadAligns() {
        this.msaPosets.putAll(LoadBench.load(new File(this.options.refFolder), this.options.refPattern, Integer.MAX_VALUE));
        for (CognateId id : this.msaPosets.keySet()) {
            this.multiAlignments.put(id, null);
        }
    }

    @Override
    public void restricMultiAlignment(CognateId id, Collection<Taxon> langs) {
        throw new RuntimeException();
    }

    @Override
    public Map<CognateId, MultiAlignment> getMultiAlignments() {
        throw new RuntimeException();
    }

    public static class BenchCorpusOptions
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Option
        public double minBranchLength = 0.005;
        @Option
        public String refFolder = "data/bench1.0/bali3/ref";
        @Option
        public String treeFolder = "data/bench1.0/bali3/weitrees";
        @Option
        public String refPattern = "BB[0-9]*";
        @Option
        public String treeExtension = "weitree";
    }
}

