/*
 * Decompiled with CFR 0.152.
 */
package ma;

import fig.basic.Option;
import goblin.CognateId;
import goblin.DerivationTree;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import ma.AffineGapAlignmentSampler;
import ma.BioCorpus;
import ma.MultiAlignment;
import ma.SequenceType;
import nuts.util.Arbre;
import nuts.util.Tree;

public class GeneratedCorpus
extends BioCorpus {
    private final GeneratedCorpusOptions options;
    private final AffineGapAlignmentSampler.TKFParams params;

    public GeneratedCorpus(GeneratedCorpusOptions options) {
        super(options.type);
        try {
            this.options = (GeneratedCorpusOptions)options.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
        this.params = options.type.defaultTKFParams();
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.options.numberOfEntries; ++i) {
            Generator gen = new Generator();
            Arbre arbre = gen.generate(new Taxon("r"), null, this.options.generationDepth);
            CognateId id = new CognateId("entry" + i);
            this.multiAlignments.put(id, MultiAlignment.inducedMultiAlignment(arbre));
            this.branchLengths.put(id, gen.currentBL);
            this.topologies.put(id, GeneratedCorpus.arbre2tree(arbre));
        }
    }

    public static Tree<String> arbre2tree(Arbre<DerivationTree.DerivationNode> arbre) {
        Tree<String> result = new Tree<String>(arbre.getContents().getLanguage().toString());
        for (Arbre<DerivationTree.DerivationNode> child : arbre.getChildren()) {
            result.getChildren().add(GeneratedCorpus.arbre2tree(child));
        }
        return result;
    }

    private class Generator {
        private final int outDegree = 2;
        private Map<Taxon, Double> currentBL = new HashMap<Taxon, Double>();

        private Generator() {
        }

        private Arbre<DerivationTree.DerivationNode> generate(Taxon newNodeName, String parentStr, int depthToGo) {
            AffineGapAlignmentSampler.CompiledTKFParams ctkf = GeneratedCorpus.this.params.compile(((GeneratedCorpus)GeneratedCorpus.this).options.branchLength);
            this.currentBL.put(newNodeName, ((GeneratedCorpus)GeneratedCorpus.this).options.branchLength);
            DerivationTree.DerivationNode node = null;
            String word = "";
            if (parentStr != null) {
                DerivationTree.Derivation randomDerivation = ctkf.generate(((GeneratedCorpus)GeneratedCorpus.this).options.dataGenRandom, parentStr);
                word = randomDerivation.getCurrentWord();
                node = new DerivationTree.DerivationNode(newNodeName, word, randomDerivation);
            } else {
                for (int i = 0; i < ((GeneratedCorpus)GeneratedCorpus.this).options.lengthOfTopWord; ++i) {
                    word = word + ctkf.generateFromStatDist(((GeneratedCorpus)GeneratedCorpus.this).options.dataGenRandom);
                }
                node = new DerivationTree.DerivationNode(newNodeName, word);
            }
            if (depthToGo > 0) {
                ArrayList children = new ArrayList();
                for (int i = 0; i < 2; ++i) {
                    children.add(this.generate(new Taxon(newNodeName.toString() + i), word, depthToGo - 1));
                }
                return Arbre.arbre(node, children);
            }
            return Arbre.arbre(node);
        }
    }

    public static final class GeneratedCorpusOptions
    implements Cloneable {
        @Option
        public int numberOfEntries = 1;
        @Option
        public int lengthOfTopWord = 20;
        @Option
        public double branchLength = 0.3;
        @Option
        public int generationDepth = 5;
        @Option
        public Random dataGenRandom = new Random(1L);
        @Option
        public SequenceType type = SequenceType.DNA;

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

