/*
 * Decompiled with CFR 0.152.
 */
package monaco.process;

import monaco.process.Monitor;
import monaco.process.ProcessSchedule;
import monaco.process.ProcessScheduleContext;

public class StandardSchedules
implements ProcessSchedule {
    private final int burnIn;
    private final int generationsPerProcessPeriod;
    private final int processesPerMonitorPeriod;
    private Monitor monitor;

    public StandardSchedules(int burnIn2, int generationsPerProcessPeriod2, int processesPerMonitorPeriod2, Monitor baseMonitor) {
        this.burnIn = burnIn2;
        this.generationsPerProcessPeriod = generationsPerProcessPeriod2;
        this.processesPerMonitorPeriod = processesPerMonitorPeriod2;
        this.monitor = baseMonitor;
        if (burnIn2 < 0 || generationsPerProcessPeriod2 < 1 || processesPerMonitorPeriod2 < 1) {
            throw new RuntimeException();
        }
    }

    @Override
    public void monitor(ProcessScheduleContext context) {
        if (this.isActive(context, this.generationsPerProcessPeriod * this.processesPerMonitorPeriod)) {
            this.monitor.monitor(context);
        }
    }

    private boolean isActive(ProcessScheduleContext context, int generationsPerPeriod) {
        int generation;
        if (context.isLastIteration()) {
            this.monitor.monitor(context);
        }
        if ((generation = context.getGeneration()) < this.burnIn) {
            return false;
        }
        return (generation - this.burnIn) % generationsPerPeriod == 0;
    }

    @Override
    public boolean shouldProcess(ProcessScheduleContext context) {
        return this.isActive(context, this.generationsPerProcessPeriod);
    }
}

