/*
 * Decompiled with CFR 0.152.
 */
package nuts.db;

import fig.basic.StrUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class SimpleDatabase {
    private final Connection conn;

    public SimpleDatabase(File f) {
        this.conn = SimpleDatabase.createConnection(f);
    }

    public static Connection createConnection(File f) {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException();
        }
        try {
            return DriverManager.getConnection("jdbc:hsqldb:" + f.getAbsolutePath(), "sa", "");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void createSimpleTable(String tableName, List<String> varChar256Fields) {
        StringBuilder query = new StringBuilder();
        query.append("CREATE TABLE " + tableName + " (");
        query.append(StrUtils.join(varChar256Fields, "VARCHAR(256),"));
        query.append("VARCHAR(256)");
        query.append(")");
    }

    public void update(String expression) {
        try {
            Statement st = this.conn.createStatement();
            int i = st.executeUpdate(expression);
            if (i == -1) {
                throw new RuntimeException("db error : " + expression);
            }
            st.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        try {
            Statement st = this.conn.createStatement();
            st.execute("SHUTDOWN");
            this.conn.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

