/*
 * Decompiled with CFR 0.152.
 */
package nuts.io;

import fig.basic.IOUtils;
import fig.basic.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import nuts.io.IteratorWrapper;
import nuts.util.CollUtils;

public class CmlSequenceReader
implements Iterator<Pair<List<String>, List<String>>> {
    private final BufferedReader reader;
    private boolean closed = false;
    private Pair<List<String>, List<String>> current = null;

    public CmlSequenceReader(BufferedReader r) {
        this.reader = r;
    }

    private boolean isSeparation(String line) {
        return line.matches("^\\s*$");
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        if (this.closed) {
            return false;
        }
        try {
            boolean success = false;
            ArrayList hidden = CollUtils.list();
            ArrayList observed = CollUtils.list();
            String line = null;
            while ((line = this.reader.readLine()) != null) {
                if (!success && this.isSeparation(line)) continue;
                if (this.isSeparation(line)) break;
                success = true;
                String[] items = line.split("\\s+");
                if (items.length != 2) {
                    throw new RuntimeException();
                }
                observed.add(items[0]);
                hidden.add(items[1]);
            }
            if (!success) {
                this.current = null;
                this.reader.close();
                this.closed = true;
                return false;
            }
            this.current = Pair.makePair(observed, hidden);
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Error while reading file.");
        }
    }

    @Override
    public Pair<List<String>, List<String>> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair<List<String>, List<String>> result = this.current;
        this.current = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static Iterable<Pair<List<String>, List<String>>> i(BufferedReader r) {
        return IteratorWrapper.IW(new CmlSequenceReader(r));
    }

    public static Iterable<Pair<List<String>, List<String>>> i(File f) {
        return CmlSequenceReader.i(IOUtils.openInEasy(f));
    }

    public static Iterable<Pair<List<String>, List<String>>> i(String f) {
        return CmlSequenceReader.i(IOUtils.openInEasy(f));
    }
}

